/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.PlatformManager;
import com.mucommander.command.AssociationBuilder;
import com.mucommander.command.AssociationFactory;
import com.mucommander.command.AssociationReader;
import com.mucommander.command.AssociationWriter;
import com.mucommander.command.Command;
import com.mucommander.command.CommandAssociation;
import com.mucommander.command.CommandBuilder;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandReader;
import com.mucommander.command.CommandWriter;
import com.mucommander.command.PermissionsFileFilter;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.ChainedFileFilter;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.RegexpFilenameFilter;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.io.backup.BackupOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandManager
implements CommandBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandManager.class);
    public static final Command RUN_AS_EXECUTABLE_COMMAND = new Command("execute", "$f", 1);
    private static final List<CommandAssociation> systemAssociations = new Vector<CommandAssociation>();
    private static final List<CommandAssociation> associations = new Vector<CommandAssociation>();
    private static AbstractFile associationFile;
    private static boolean wereAssociationsModified;
    private static Map<String, Command> commands;
    private static AbstractFile commandsFile;
    private static boolean wereCommandsModified;
    private static Command defaultCommand;

    private CommandManager() {
    }

    private static Command getCommandForFile(AbstractFile file, Iterator<CommandAssociation> iterator) {
        while (iterator.hasNext()) {
            CommandAssociation association = iterator.next();
            if (!association.accept(file)) continue;
            return association.getCommand();
        }
        return null;
    }

    public static Command getCommandForFile(AbstractFile file, boolean allowDefault) {
        Command command = CommandManager.getCommandForFile(file, associations.iterator());
        if (command != null) {
            return command;
        }
        command = CommandManager.getCommandForFile(file, systemAssociations.iterator());
        if (command != null) {
            return command;
        }
        if (defaultCommand != null) {
            return defaultCommand;
        }
        if (allowDefault) {
            return RUN_AS_EXECUTABLE_COMMAND;
        }
        return null;
    }

    public static Iterator<Command> commands() {
        Vector<Command> list = new Vector<Command>(commands.size());
        list.addAll(commands.values());
        Collections.sort(list);
        return list.iterator();
    }

    public static Command getCommandForAlias(String alias) {
        return commands.get(alias);
    }

    private static void setDefaultCommand(Command command) {
        if (defaultCommand == null && command.getAlias().equals("open")) {
            LOGGER.debug("Registering '" + command.getCommand() + "' as default command.");
            defaultCommand = command;
        }
    }

    private static void registerCommand(Command command, boolean mark) throws CommandException {
        CommandManager.setDefaultCommand(command);
        LOGGER.debug("Registering '" + command.getCommand() + "' as '" + command.getAlias() + "'");
        Command oldCommand = commands.put(command.getAlias(), command);
        if (mark && !command.equals(oldCommand)) {
            wereCommandsModified = true;
        }
    }

    public static void registerDefaultCommand(Command command) throws CommandException {
        CommandManager.registerCommand(command, false);
    }

    public static void registerCommand(Command command) throws CommandException {
        CommandManager.registerCommand(command, true);
    }

    private static Iterator<CommandAssociation> associations() {
        return associations.iterator();
    }

    public static void registerAssociation(String command, FileFilter filter) throws CommandException {
        associations.add(CommandManager.createAssociation(command, filter));
    }

    private static CommandAssociation createAssociation(String cmd, FileFilter filter) throws CommandException {
        Command command = CommandManager.getCommandForAlias(cmd);
        if (command == null) {
            LOGGER.debug("Failed to create association as '" + command + "' is not known.");
            throw new CommandException(command + " not found");
        }
        return new CommandAssociation(command, filter);
    }

    public static void registerDefaultAssociation(String command, FileFilter filter) throws CommandException {
        systemAssociations.add(CommandManager.createAssociation(command, filter));
    }

    @Override
    public void addCommand(Command command) throws CommandException {
        CommandManager.registerCommand(command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildCommands(CommandBuilder builder) throws CommandException {
        builder.startBuilding();
        Iterator<Command> iterator = CommandManager.commands();
        try {
            while (iterator.hasNext()) {
                builder.addCommand(iterator.next());
            }
        }
        finally {
            builder.endBuilding();
        }
    }

    private static void buildFilter(FileFilter filter, AssociationBuilder builder) throws CommandException {
        if (filter instanceof AttributeFileFilter) {
            AttributeFileFilter attributeFilter = (AttributeFileFilter)filter;
            switch (attributeFilter.getAttribute()) {
                case 5: {
                    builder.setIsHidden(!attributeFilter.isInverted());
                    break;
                }
                case 4: {
                    builder.setIsSymlink(!attributeFilter.isInverted());
                }
            }
        } else if (filter instanceof PermissionsFileFilter) {
            PermissionsFileFilter permissionFilter = (PermissionsFileFilter)filter;
            switch (permissionFilter.getPermission()) {
                case 4: {
                    builder.setIsReadable(permissionFilter.getFilter());
                    break;
                }
                case 2: {
                    builder.setIsWritable(permissionFilter.getFilter());
                    break;
                }
                case 1: {
                    builder.setIsExecutable(permissionFilter.getFilter());
                }
            }
        } else if (filter instanceof RegexpFilenameFilter) {
            RegexpFilenameFilter regexpFilter = (RegexpFilenameFilter)filter;
            builder.setMask(regexpFilter.getRegularExpression(), regexpFilter.isCaseSensitive());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildAssociations(AssociationBuilder builder) throws CommandException {
        builder.startBuilding();
        Iterator<CommandAssociation> iterator = CommandManager.associations();
        try {
            while (iterator.hasNext()) {
                CommandAssociation current = iterator.next();
                builder.startAssociation(current.getCommand().getAlias());
                FileFilter filter = current.getFilter();
                if (filter instanceof ChainedFileFilter) {
                    Iterator<FileFilter> filters = ((ChainedFileFilter)filter).getFileFilterIterator();
                    while (filters.hasNext()) {
                        CommandManager.buildFilter(filters.next(), builder);
                    }
                } else {
                    CommandManager.buildFilter(filter, builder);
                }
                builder.endAssociation();
            }
        }
        finally {
            builder.endBuilding();
        }
    }

    public static AbstractFile getAssociationFile() throws IOException {
        if (associationFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("associations.xml");
        }
        return associationFile;
    }

    public static void setAssociationFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            CommandManager.setAssociationFile(new File(path));
        } else {
            CommandManager.setAssociationFile(file);
        }
    }

    public static void setAssociationFile(File file) throws FileNotFoundException {
        CommandManager.setAssociationFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static void setAssociationFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        associationFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadAssociations() throws IOException, CommandException {
        AbstractFile file = CommandManager.getAssociationFile();
        LOGGER.debug("Loading associations from file: " + file.getAbsolutePath());
        BackupInputStream in = null;
        try {
            in = new BackupInputStream(file);
            AssociationReader.read(in, new AssociationFactory());
        }
        finally {
            wereAssociationsModified = false;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAssociations() throws CommandException, IOException {
        if (wereAssociationsModified) {
            LOGGER.debug("Writing associations to file: " + CommandManager.getAssociationFile());
            BackupOutputStream out = null;
            try {
                out = new BackupOutputStream(CommandManager.getAssociationFile());
                CommandManager.buildAssociations(new AssociationWriter(out));
                wereAssociationsModified = false;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        LOGGER.debug("Custom file associations not modified, skip saving.");
    }

    public static AbstractFile getCommandFile() throws IOException {
        if (commandsFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("commands.xml");
        }
        return commandsFile;
    }

    public static void setCommandFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            CommandManager.setCommandFile(new File(path));
        } else {
            CommandManager.setCommandFile(file);
        }
    }

    public static void setCommandFile(File file) throws FileNotFoundException {
        CommandManager.setCommandFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static void setCommandFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        commandsFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCommands() throws IOException, CommandException {
        if (wereCommandsModified) {
            LOGGER.debug("Writing custom commands to file: " + CommandManager.getCommandFile());
            BackupOutputStream out = null;
            try {
                out = new BackupOutputStream(CommandManager.getCommandFile());
                CommandManager.buildCommands(new CommandWriter(out));
                wereCommandsModified = false;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        LOGGER.debug("Custom commands not modified, skip saving.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCommands() throws IOException, CommandException {
        AbstractFile file = CommandManager.getCommandFile();
        LOGGER.debug("Loading custom commands from: " + file.getAbsolutePath());
        BackupInputStream in = null;
        try {
            in = new BackupInputStream(file);
            CommandReader.read(in, new CommandManager());
        }
        finally {
            wereCommandsModified = false;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void startBuilding() {
    }

    @Override
    public void endBuilding() {
    }

    static {
        commands = new Hashtable<String, Command>();
        defaultCommand = null;
    }
}

