/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.command.Command;
import com.mucommander.command.CommandBuilder;
import com.mucommander.command.CommandException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CommandReader
extends DefaultHandler {
    private CommandBuilder builder;

    private CommandReader(CommandBuilder b) {
        this.builder = b;
    }

    public static void read(InputStream in, CommandBuilder b) throws CommandException, IOException {
        b.startBuilding();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)new CommandReader(b));
        }
        catch (ParserConfigurationException e) {
            throw new CommandException(e);
        }
        catch (SAXException e) {
            throw new CommandException(e);
        }
        finally {
            b.endBuilding();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("command")) {
            String command;
            String alias = attributes.getValue("alias");
            if (alias == null || (command = attributes.getValue("value")) == null) {
                return;
            }
            int type = CommandReader.parseCommandType(attributes.getValue("type"));
            String display = attributes.getValue("display");
            try {
                this.builder.addCommand(new Command(alias, command, type, display));
            }
            catch (CommandException e) {
                throw new SAXException(e);
            }
        }
    }

    private static int parseCommandType(String type) {
        if (type == null) {
            return 0;
        }
        if (type.equals("system")) {
            return 1;
        }
        if (type.equals("invisible")) {
            return 2;
        }
        return 0;
    }
}

