/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.command.Command;
import com.mucommander.command.CommandBuilder;
import com.mucommander.command.CommandException;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;

public class CommandWriter
implements CommandBuilder {
    private XmlWriter out;

    public CommandWriter(OutputStream stream) throws IOException {
        this.out = new XmlWriter(stream);
    }

    public void startBuilding() throws CommandException {
        try {
            this.out.startElement("commands");
            this.out.println();
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void endBuilding() throws CommandException {
        try {
            this.out.endElement("commands");
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void addCommand(Command command) throws CommandException {
        XmlAttributes attributes = new XmlAttributes();
        attributes.add("alias", command.getAlias());
        attributes.add("value", command.getCommand());
        if (command.getType() == 1) {
            attributes.add("type", "system");
        } else if (command.getType() == 2) {
            attributes.add("type", "invisible");
        }
        if (command.isDisplayNameSet()) {
            attributes.add("display", command.getDisplayName());
        }
        try {
            this.out.writeStandAloneElement("command", attributes);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }
}

