/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.conf;

import com.mucommander.commons.conf.ValueList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationSection {
    private final Map<String, String> variables = new HashMap<String, String>();
    private final Map<String, ConfigurationSection> sections = new HashMap<String, ConfigurationSection>();

    public String removeVariable(String name) {
        return this.variables.remove(name);
    }

    public String getVariable(String name) {
        return this.variables.get(name);
    }

    public boolean setVariable(String name, String value) {
        if (value == null || value.trim().equals("")) {
            if (this.getVariable(name) == null) {
                return false;
            }
            this.removeVariable(name);
            return true;
        }
        String buffer = this.variables.put(name, value);
        return buffer == null || !buffer.equals(value);
    }

    public Iterator<String> variableNames() {
        return this.variables.keySet().iterator();
    }

    public boolean hasVariables() {
        return !this.variables.isEmpty();
    }

    public static int getIntegerValue(String value) {
        return value == null ? 0 : Integer.parseInt(value);
    }

    public static ValueList getListValue(String value, String separator) {
        return value == null ? null : new ValueList(value, separator);
    }

    public static float getFloatValue(String value) {
        return value == null ? 0.0f : Float.parseFloat(value);
    }

    public static boolean getBooleanValue(String value) {
        return Boolean.TRUE.toString().equals(value);
    }

    public static long getLongValue(String value) {
        return value == null ? 0L : Long.parseLong(value);
    }

    public static String getValue(int value) {
        return Integer.toString(value);
    }

    public static String getValue(List<String> value, String separator) {
        return ValueList.toString(value, separator);
    }

    public static String getValue(float value) {
        return Float.toString(value);
    }

    public static String getValue(boolean value) {
        return Boolean.toString(value);
    }

    public static String getValue(long value) {
        return Long.toString(value);
    }

    public ConfigurationSection addSection(String name) {
        ConfigurationSection section = this.getSection(name);
        if (section != null) {
            return section;
        }
        section = new ConfigurationSection();
        this.sections.put(name, section);
        return section;
    }

    public ConfigurationSection removeSection(String name) {
        return this.sections.remove(name);
    }

    public boolean removeSection(ConfigurationSection section) {
        Iterator<String> sectionNames = this.sectionNames();
        while (sectionNames.hasNext()) {
            String name = sectionNames.next();
            if (!this.getSection(name).equals(section)) continue;
            this.removeSection(name);
            return true;
        }
        return false;
    }

    public ConfigurationSection getSection(String name) {
        return this.sections.get(name);
    }

    public Iterator<String> sectionNames() {
        return this.sections.keySet().iterator();
    }

    public boolean hasSections() {
        return !this.sections.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasSections() && !this.hasVariables();
    }

    public void clear() {
        this.variables.clear();
        this.sections.clear();
    }
}

