/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.conf;

import com.mucommander.commons.conf.ConfigurationBuilder;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.commons.conf.ConfigurationFormatException;
import com.mucommander.commons.conf.ConfigurationReader;
import com.mucommander.commons.conf.ConfigurationReaderFactory;
import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConfigurationReader
extends DefaultHandler
implements ConfigurationReader {
    public static final ConfigurationReaderFactory<XmlConfigurationReader> FACTORY = new ConfigurationReaderFactory<XmlConfigurationReader>(){};
    private int depth;
    private final StringBuilder buffer = new StringBuilder();
    private String itemName;
    protected ConfigurationBuilder builder;
    private boolean isVariable;
    private Locator locator;

    public void read(Reader in, ConfigurationBuilder builder) throws IOException, ConfigurationException, ConfigurationFormatException {
        this.builder = builder;
        this.locator = null;
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(in), (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Failed to create a SAX parser", e);
        }
        catch (SAXParseException e) {
            throw new ConfigurationFormatException(e.getMessage(), e.getLineNumber(), e.getColumnNumber());
        }
        catch (SAXException e) {
            throw new ConfigurationFormatException(e.getException() == null ? e : e.getException());
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.buffer.append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.depth;
        if (this.depth == 1) {
            return;
        }
        if (this.itemName != null) {
            try {
                this.builder.startSection(this.itemName);
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.locator, e);
            }
        }
        this.buffer.setLength(0);
        this.itemName = qName;
        this.isVariable = true;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this.depth;
        if (this.depth == 0) {
            return;
        }
        if (this.isVariable) {
            String value = this.buffer.toString().trim();
            if (!value.isEmpty()) {
                try {
                    this.builder.addVariable(qName, value);
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), this.locator, e);
                }
            }
        } else {
            try {
                this.builder.endSection(qName);
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this.locator, e);
            }
        }
        this.isVariable = false;
        this.itemName = null;
    }

    public void startDocument() throws SAXException {
        try {
            this.builder.startConfiguration();
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.builder.endConfiguration();
        }
        catch (Exception e) {
            throw new SAXParseException(e.getMessage(), this.locator, e);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

