/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.conf;

import com.mucommander.commons.conf.ConfigurationBuilder;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.commons.conf.ConfigurationWriterFactory;
import java.io.Writer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlConfigurationWriter
implements ConfigurationBuilder {
    public static final ConfigurationWriterFactory<XmlConfigurationWriter> FACTORY = new ConfigurationWriterFactory<XmlConfigurationWriter>(){

        @Override
        public XmlConfigurationWriter getWriterInstance(Writer out) {
            return new XmlConfigurationWriter(out, this.getRootElementName());
        }
    };
    protected final ContentHandler out;
    private final Attributes emptyAttributes = new AttributesImpl();
    protected final String rootElementName;

    protected XmlConfigurationWriter(Writer out, String rootElementName) {
        this.rootElementName = rootElementName;
        this.out = XmlConfigurationWriter.createHandler(out);
    }

    private static ContentHandler createHandler(Writer out) {
        TransformerHandler transformer;
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        factory.setAttribute("indent-number", 4);
        try {
            transformer = factory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        transformer.getTransformer().setOutputProperty("indent", "yes");
        transformer.getTransformer().setOutputProperty("standalone", "yes");
        transformer.setResult(new StreamResult(out));
        return transformer;
    }

    protected void startElement(String name) throws ConfigurationException {
        try {
            this.out.startElement("", name, name, this.emptyAttributes);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    protected void endElement(String name) throws ConfigurationException {
        try {
            this.out.endElement("", name, name);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    public void startSection(String name) throws ConfigurationException {
        this.startElement(name);
    }

    public void endSection(String name) throws ConfigurationException {
        this.endElement(name);
    }

    public void addVariable(String name, String value) throws ConfigurationException {
        try {
            this.startElement(name);
            char[] data = value.toCharArray();
            this.out.characters(data, 0, data.length);
            this.endElement(name);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    public void startConfiguration() throws ConfigurationException {
        try {
            this.out.startDocument();
            this.startElement(this.rootElementName);
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
    }

    public void endConfiguration() throws ConfigurationException {
        try {
            this.endElement(this.rootElementName);
            this.out.endDocument();
        }
        catch (SAXException e) {
            throw new ConfigurationException(e);
        }
    }
}

