/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.ArchiveEntryTree;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.ROArchiveEntryFile;
import com.mucommander.commons.file.RWArchiveEntryFile;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.file.impl.ProxyFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractArchiveFile
extends ProxyFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArchiveFile.class);
    protected ArchiveEntryTree entryTreeRoot;
    protected long entryTreeDate;
    protected WeakHashMap<ArchiveEntry, AbstractArchiveEntryFile> archiveEntryFiles;

    protected AbstractArchiveFile(AbstractFile file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEntriesTree() throws IOException, UnsupportedFileOperationException {
        ArchiveEntryTree treeRoot = new ArchiveEntryTree();
        this.archiveEntryFiles = new WeakHashMap();
        long start = System.currentTimeMillis();
        ArchiveEntryIterator entries = this.getEntryIterator();
        try {
            ArchiveEntry entry;
            while ((entry = entries.nextEntry()) != null) {
                treeRoot.addArchiveEntry(entry);
            }
            LOGGER.info("entries tree created in " + (System.currentTimeMillis() - start) + " ms");
            this.entryTreeRoot = treeRoot;
            this.declareEntriesTreeUpToDate();
        }
        finally {
            try {
                entries.close();
            }
            catch (IOException e) {}
        }
    }

    protected void checkEntriesTree() throws IOException, UnsupportedFileOperationException {
        if (this.entryTreeRoot == null || this.getDate() != this.entryTreeDate) {
            this.createEntriesTree();
        }
    }

    protected void declareEntriesTreeUpToDate() {
        this.entryTreeDate = this.getDate();
    }

    protected void addToEntriesTree(ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        this.checkEntriesTree();
        this.entryTreeRoot.addArchiveEntry(entry);
    }

    protected void removeFromEntriesTree(ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        this.checkEntriesTree();
        DefaultMutableTreeNode entryNode = this.entryTreeRoot.findEntryNode(entry.getPath());
        if (entryNode != null) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)entryNode.getParent();
            parentNode.remove(entryNode);
        }
    }

    ArchiveEntryTree getArchiveEntryTree() {
        return this.entryTreeRoot;
    }

    protected AbstractFile[] ls(AbstractArchiveEntryFile entryFile, FilenameFilter filenameFilter, FileFilter fileFilter) throws IOException, UnsupportedFileOperationException {
        this.checkEntriesTree();
        if (!entryFile.isBrowsable()) {
            throw new IOException();
        }
        DefaultMutableTreeNode matchNode = this.entryTreeRoot.findEntryNode(entryFile.getEntry().getPath());
        if (matchNode == null) {
            throw new IOException();
        }
        return this.ls(matchNode, entryFile, filenameFilter, fileFilter);
    }

    private AbstractFile[] ls(DefaultMutableTreeNode treeNode, AbstractFile parentFile, FilenameFilter filenameFilter, FileFilter fileFilter) throws IOException, UnsupportedFileOperationException {
        AbstractFile[] files;
        int nbChildren = treeNode.getChildCount();
        if (filenameFilter == null) {
            files = new AbstractFile[nbChildren];
            for (int c = 0; c < nbChildren; ++c) {
                files[c] = this.getArchiveEntryFile((ArchiveEntry)((DefaultMutableTreeNode)treeNode.getChildAt(c)).getUserObject(), parentFile);
            }
        } else {
            Vector<AbstractFile> filesV = new Vector<AbstractFile>();
            for (int c = 0; c < nbChildren; ++c) {
                ArchiveEntry entry = (ArchiveEntry)((DefaultMutableTreeNode)treeNode.getChildAt(c)).getUserObject();
                if (!filenameFilter.accept(entry.getName())) continue;
                filesV.add(this.getArchiveEntryFile(entry, parentFile));
            }
            files = new AbstractFile[filesV.size()];
            filesV.toArray(files);
        }
        return fileFilter == null ? files : fileFilter.filter(files);
    }

    protected AbstractFile getArchiveEntryFile(ArchiveEntry entry, AbstractFile parentFile) throws IOException {
        AbstractArchiveEntryFile entryFile;
        String entryPath = entry.getPath();
        String fileSeparator = this.getSeparator();
        if (!fileSeparator.equals("/")) {
            entryPath = entryPath.replace("/", fileSeparator);
        }
        if ((entryFile = this.archiveEntryFiles.get(entry)) == null) {
            FileURL archiveURL = this.getURL();
            FileURL entryURL = (FileURL)archiveURL.clone();
            entryURL.setPath(this.addTrailingSeparator(archiveURL.getPath()) + entryPath);
            entryFile = this instanceof AbstractRWArchiveFile ? new RWArchiveEntryFile(entryURL, this, entry) : new ROArchiveEntryFile(entryURL, this, entry);
            entryFile.setParent(parentFile);
            this.archiveEntryFiles.put(entry, entryFile);
        }
        return FileFactory.wrapArchive(entryFile);
    }

    public AbstractFile getArchiveEntryFile(String entryPath) throws IOException, UnsupportedFileOperationException {
        this.checkEntriesTree();
        entryPath = entryPath.replace('\\', '/');
        DefaultMutableTreeNode entryNode = this.entryTreeRoot.findEntryNode(entryPath);
        if (entryNode == null) {
            AbstractFile parentFile;
            int depth = ArchiveEntry.getDepth(entryPath);
            if (depth == 1) {
                parentFile = this;
            } else {
                String parentPath = entryPath;
                if (parentPath.endsWith("/")) {
                    parentPath = parentPath.substring(0, parentPath.length() - 1);
                }
                if ((parentFile = this.getArchiveEntryFile(parentPath = parentPath.substring(0, parentPath.lastIndexOf(47)))) == null) {
                    throw new IOException();
                }
            }
            return this.getArchiveEntryFile(new ArchiveEntry(entryPath, false, 0L, 0L, false), parentFile);
        }
        return this.getArchiveEntryFile(entryNode);
    }

    protected AbstractFile getArchiveEntryFile(DefaultMutableTreeNode entryNode) throws IOException {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)entryNode.getParent();
        return this.getArchiveEntryFile((ArchiveEntry)entryNode.getUserObject(), parentNode == this.entryTreeRoot ? this : this.getArchiveEntryFile(parentNode));
    }

    public abstract ArchiveEntryIterator getEntryIterator() throws IOException, UnsupportedFileOperationException;

    public abstract InputStream getEntryInputStream(ArchiveEntry var1, ArchiveEntryIterator var2) throws IOException, UnsupportedFileOperationException;

    public abstract boolean isWritable();

    public boolean isArchive() {
        return this.exists() && !this.isDirectory();
    }

    public AbstractFile[] ls() throws IOException, UnsupportedFileOperationException {
        if (!this.isArchive()) {
            return super.ls();
        }
        this.checkEntriesTree();
        return this.ls(this.entryTreeRoot, this, null, null);
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException, UnsupportedFileOperationException {
        if (!this.isArchive()) {
            return super.ls(filter);
        }
        this.checkEntriesTree();
        return this.ls(this.entryTreeRoot, this, filter, null);
    }

    public AbstractFile[] ls(FileFilter filter) throws IOException, UnsupportedFileOperationException {
        if (!this.isArchive()) {
            return super.ls(filter);
        }
        this.checkEntriesTree();
        return this.ls(this.entryTreeRoot, this, null, filter);
    }
}

