/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.SimpleFileAttributes;
import com.mucommander.commons.file.util.PathUtils;

public class ArchiveEntry
extends SimpleFileAttributes {
    protected Object entryObject;
    private int hashCode;

    public ArchiveEntry() {
    }

    public ArchiveEntry(String path, boolean directory, long date, long size, boolean exists) {
        this.setPath(path);
        this.setDate(date);
        this.setSize(size);
        this.setDirectory(directory);
        this.setExists(exists);
    }

    public int getDepth() {
        return ArchiveEntry.getDepth(this.getPath());
    }

    public static int getDepth(String entryPath) {
        return PathUtils.getDepth(entryPath, "/");
    }

    public String getName() {
        int lastSlash;
        int len;
        String path = this.getPath();
        if (path.charAt((len = path.length()) - 1) == '/') {
            path = path.substring(0, --len);
        }
        return (lastSlash = path.lastIndexOf(47)) == -1 ? path : path.substring(lastSlash + 1, len);
    }

    public Object getEntryObject() {
        return this.entryObject;
    }

    public void setEntryObject(Object entryObject) {
        this.entryObject = entryObject;
    }

    public FilePermissions getPermissions() {
        FilePermissions permissions = super.getPermissions();
        if (permissions == null) {
            return this.isDirectory() ? FilePermissions.DEFAULT_DIRECTORY_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS;
        }
        return permissions;
    }

    public void setPath(String path) {
        super.setPath(path);
        this.hashCode = 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArchiveEntry)) {
            return false;
        }
        return PathUtils.pathEquals(this.getPath(), ((ArchiveEntry)o).getPath(), "/");
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        String path = this.getPath();
        this.hashCode = path.endsWith("/") ? path.substring(0, path.length() - 1).hashCode() : path.hashCode();
        return this.hashCode;
    }
}

