/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.PathCanonizer;
import java.util.Vector;

public class DefaultPathCanonizer
implements PathCanonizer {
    private String separator;
    private String tildeReplacement;

    public DefaultPathCanonizer(String separator, String tildeReplacement) {
        this.separator = separator;
        this.tildeReplacement = tildeReplacement;
    }

    public String canonize(String path) {
        if (!path.equals("/")) {
            int pos;
            int pos2 = 0;
            int separatorLen = this.separator.length();
            Vector<String> pathV = new Vector<String>();
            while ((pos = pos2) != -1) {
                String dirWS;
                String dir;
                pos2 = path.indexOf(this.separator, pos);
                if (pos2 == -1) {
                    dirWS = dir = path.substring(pos);
                } else {
                    dir = path.substring(pos, pos2 += separatorLen);
                    dirWS = dir.substring(0, dir.length() - separatorLen);
                }
                if (dirWS.equals("") && pathV.size() > 0 || dirWS.equals(".")) continue;
                if (dirWS.equals("..")) {
                    if (pathV.size() <= 0) continue;
                    pathV.removeElementAt(pathV.size() - 1);
                    continue;
                }
                if (this.tildeReplacement != null && dirWS.equals("~")) {
                    path = path.substring(0, pos) + this.tildeReplacement + path.substring(pos + 1);
                    pos2 = pos;
                    continue;
                }
                pathV.add(dir);
            }
            path = "";
            int nbDirs = pathV.size();
            for (int i = 0; i < nbDirs; ++i) {
                path = path + (String)pathV.elementAt(i);
            }
        }
        return path;
    }
}

