/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AuthenticationType;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.DefaultSchemeParser;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.SchemeHandler;
import com.mucommander.commons.file.SchemeParser;

public class DefaultSchemeHandler
implements SchemeHandler {
    protected SchemeParser parser;
    protected int standardPort;
    protected String pathSeparator;
    protected AuthenticationType authenticationType;
    protected Credentials guestCredentials;

    public DefaultSchemeHandler() {
        this(new DefaultSchemeParser(), -1, System.getProperty("file.separator"), AuthenticationType.NO_AUTHENTICATION, null);
    }

    public DefaultSchemeHandler(SchemeParser parser, int standardPort, String pathSeparator, AuthenticationType authenticationType, Credentials guestCredentials) {
        this.parser = parser;
        this.standardPort = standardPort;
        this.pathSeparator = pathSeparator;
        this.authenticationType = authenticationType;
        this.guestCredentials = guestCredentials;
    }

    public SchemeParser getParser() {
        return this.parser;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public Credentials getGuestCredentials() {
        return this.guestCredentials;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public int getStandardPort() {
        return this.standardPort;
    }

    public FileURL getRealm(FileURL location) {
        FileURL realm = (FileURL)location.clone();
        realm.setPath(location.getPathSeparator());
        realm.setCredentials(null);
        realm.setQuery(null);
        return realm;
    }
}

