/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.DefaultPathCanonizer;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PathCanonizer;
import com.mucommander.commons.file.SchemeHandler;
import com.mucommander.commons.file.SchemeParser;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.runtime.OsFamilies;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemeParser
implements SchemeParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSchemeParser.class);
    protected boolean parseQuery;
    protected PathCanonizer pathCanonizer;

    public DefaultSchemeParser() {
        this(false);
    }

    public DefaultSchemeParser(boolean parseQuery) {
        this(new DefaultPathCanonizer(System.getProperty("file.separator"), null), parseQuery);
    }

    public DefaultSchemeParser(PathCanonizer pathCanonizer, boolean parseQuery) {
        this.parseQuery = parseQuery;
        this.pathCanonizer = pathCanonizer;
    }

    private void handleLocalFilePath(String url, FileURL fileURL) {
        SchemeHandler handler = FileURL.getRegisteredHandler("file");
        SchemeParser parser = handler.getParser();
        fileURL.setHandler(handler);
        fileURL.setScheme("file");
        fileURL.setHost("localhost");
        fileURL.setPath((parser instanceof DefaultSchemeParser ? ((DefaultSchemeParser)parser).getPathCanonizer() : this.pathCanonizer).canonize(url));
    }

    public PathCanonizer getPathCanonizer() {
        return this.pathCanonizer;
    }

    public void parse(String url, FileURL fileURL) throws MalformedURLException {
        try {
            String host;
            int colonPos;
            int questionMarkPos;
            int pos;
            int schemeDelimPos = url.indexOf("://");
            int urlLen = url.length();
            if (schemeDelimPos == -1) {
                if (!LocalFile.USES_ROOT_DRIVES && url.startsWith("/") || url.startsWith("~")) {
                    this.handleLocalFilePath(url, fileURL);
                    return;
                }
                if (LocalFile.USES_ROOT_DRIVES && (url.indexOf(":\\") == 1 || url.indexOf(":/") == 1)) {
                    if (url.charAt(2) == '/') {
                        url = url.replace('/', '\\');
                    }
                    this.handleLocalFilePath(url, fileURL);
                    return;
                }
                if (url.startsWith("\\\\") && urlLen > 2) {
                    if (OsFamilies.WINDOWS.isCurrent()) {
                        pos = url.indexOf(92, 2);
                        url = "file://" + (pos == -1 ? url.substring(2) : url.substring(2, pos) + "/" + (pos == urlLen - 1 ? "" : url.substring(pos + 1)));
                        schemeDelimPos = "file".length();
                    } else {
                        url = "smb://" + url.substring(2).replace('\\', '/');
                        schemeDelimPos = "smb".length();
                    }
                    urlLen = url.length();
                } else {
                    throw new MalformedURLException("Path not absolute or malformed: " + url);
                }
            }
            String scheme = url.substring(0, schemeDelimPos);
            fileURL.setScheme(scheme);
            pos = schemeDelimPos + 3;
            int separatorPos = url.indexOf(47, pos);
            int n = questionMarkPos = this.parseQuery ? url.indexOf(63, pos) : -1;
            int hostEndPos = separatorPos != -1 ? separatorPos : (questionMarkPos != -1 ? questionMarkPos : urlLen);
            String authority = url.substring(pos, hostEndPos);
            pos = 0;
            int atPos = authority.lastIndexOf(64);
            if (atPos != -1 && (separatorPos == -1 || atPos < separatorPos)) {
                colonPos = authority.indexOf(58);
                String login = URLDecoder.decode(authority.substring(0, colonPos == -1 ? atPos : colonPos), "UTF-8");
                String password = colonPos != -1 ? URLDecoder.decode(authority.substring(colonPos + 1, atPos), "UTF-8") : null;
                if (!"".equals(login) || password != null && !"".equals(password)) {
                    fileURL.setCredentials(new Credentials(login, password));
                }
                pos = atPos + 1;
            }
            if ((colonPos = authority.indexOf(58, pos)) != -1) {
                host = authority.substring(pos, colonPos);
                String portString = authority.substring(colonPos + 1);
                if (!portString.equals("")) {
                    try {
                        fileURL.setPort(Integer.parseInt(portString));
                    }
                    catch (NumberFormatException e) {
                        throw new MalformedURLException("URL contains an invalid port");
                    }
                }
            } else {
                host = authority.substring(pos);
            }
            if (host.equals("")) {
                host = null;
            }
            fileURL.setHost(host);
            pos = hostEndPos;
            String path = url.substring(pos, questionMarkPos == -1 ? urlLen : questionMarkPos);
            if (path.equals("")) {
                path = "/";
            }
            fileURL.setPath(this.pathCanonizer.canonize(path));
            LOGGER.info("Warning: path should not be empty, url={}", url);
            if (questionMarkPos != -1) {
                fileURL.setQuery(url.substring(questionMarkPos + 1));
            }
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (Exception e2) {
            LOGGER.info("Unexpected exception in FileURL() with " + url, e2);
            throw new MalformedURLException();
        }
    }
}

