/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryTree;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.io.ByteCounter;
import com.mucommander.commons.io.CounterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.tree.DefaultMutableTreeNode;

public class RWArchiveEntryFile
extends AbstractArchiveEntryFile {
    protected RWArchiveEntryFile(FileURL url, AbstractArchiveFile archiveFile, ArchiveEntry entry) {
        super(url, archiveFile, entry);
    }

    private boolean updateEntryAttributes() {
        try {
            ((AbstractRWArchiveFile)this.archiveFile).updateEntry(this.entry);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void changeDate(long lastModified) throws IOException, UnsupportedFileOperationException {
        if (!this.entry.exists()) {
            throw new IOException();
        }
        long oldDate = this.entry.getDate();
        this.entry.setDate(lastModified);
        boolean success = this.updateEntryAttributes();
        if (!success) {
            this.entry.setDate(oldDate);
            throw new IOException();
        }
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.FULL_PERMISSION_BITS;
    }

    public void delete() throws IOException, UnsupportedFileOperationException {
        DefaultMutableTreeNode node;
        ArchiveEntryTree tree;
        if (!this.entry.exists()) {
            throw new IOException();
        }
        AbstractRWArchiveFile rwArchiveFile = (AbstractRWArchiveFile)this.archiveFile;
        if (this.isDirectory() && (tree = rwArchiveFile.getArchiveEntryTree()) != null && (node = tree.findEntryNode(this.entry.getPath())) != null && node.getChildCount() > 0) {
            throw new IOException();
        }
        rwArchiveFile.deleteEntry(this.entry);
        this.entry.setDirectory(false);
        this.entry.setSize(0L);
        this.entry.setExists(false);
    }

    public void mkdir() throws IOException, UnsupportedFileOperationException {
        if (this.entry.exists()) {
            throw new IOException();
        }
        AbstractRWArchiveFile rwArchivefile = (AbstractRWArchiveFile)this.archiveFile;
        this.entry.setDirectory(true);
        this.entry.setDate(System.currentTimeMillis());
        this.entry.setSize(0L);
        rwArchivefile.addEntry(this.entry);
        this.entry.setExists(true);
    }

    public OutputStream getOutputStream() throws IOException, UnsupportedFileOperationException {
        if (this.entry.exists()) {
            try {
                this.delete();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        CounterOutputStream out = new CounterOutputStream(((AbstractRWArchiveFile)this.archiveFile).addEntry(this.entry), new ByteCounter(){

            public synchronized void add(long nbBytes) {
                RWArchiveEntryFile.this.entry.setSize(RWArchiveEntryFile.this.entry.getSize() + nbBytes);
                RWArchiveEntryFile.this.entry.setDate(System.currentTimeMillis());
            }
        });
        this.entry.setExists(true);
        return out;
    }

    public void changePermissions(int permissions) throws IOException {
        if (!this.entry.exists()) {
            throw new IOException();
        }
        FilePermissions oldPermissions = this.entry.getPermissions();
        SimpleFilePermissions newPermissions = new SimpleFilePermissions(permissions, oldPermissions.getMask());
        this.entry.setPermissions(newPermissions);
        boolean success = this.updateEntryAttributes();
        if (!success) {
            this.entry.setPermissions(oldPermissions);
        }
        if (!success) {
            throw new IOException();
        }
    }
}

