/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.SimpleFileAttributes;

public abstract class SyncedFileAttributes
extends SimpleFileAttributes {
    private long ttl;
    private long expirationDate;
    private boolean isUpdating;

    public SyncedFileAttributes(long ttl, boolean updateAttributesNow) {
        this.setTtl(ttl);
        if (updateAttributesNow) {
            this.checkForExpiration(true);
        }
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
        this.updateExpirationDate();
    }

    public void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void updateExpirationDate() {
        this.setExpirationDate(this.ttl < 0L ? Long.MAX_VALUE : System.currentTimeMillis() + this.getTtl());
    }

    public boolean hasExpired() {
        return this.ttl >= 0L && !this.isUpdating() && System.currentTimeMillis() > this.expirationDate;
    }

    private synchronized boolean isUpdating() {
        return this.isUpdating;
    }

    private synchronized void setUpdating(boolean isUpdating) {
        this.isUpdating = isUpdating;
    }

    protected void checkForExpiration(boolean forceUpdate) {
        if (forceUpdate || this.hasExpired()) {
            this.setUpdating(true);
            this.updateAttributes();
            this.updateExpirationDate();
            this.setUpdating(false);
        }
    }

    public String getPath() {
        this.checkForExpiration(false);
        return super.getPath();
    }

    public boolean exists() {
        this.checkForExpiration(false);
        return super.exists();
    }

    public long getDate() {
        this.checkForExpiration(false);
        return super.getDate();
    }

    public long getSize() {
        this.checkForExpiration(false);
        return super.getSize();
    }

    public boolean isDirectory() {
        this.checkForExpiration(false);
        return super.isDirectory();
    }

    public FilePermissions getPermissions() {
        this.checkForExpiration(false);
        return super.getPermissions();
    }

    public String getOwner() {
        this.checkForExpiration(false);
        return super.getOwner();
    }

    public String getGroup() {
        this.checkForExpiration(false);
        return super.getGroup();
    }

    public abstract void updateAttributes();
}

