/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.archiver;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.archiver.SingleFileArchiver;
import com.mucommander.commons.file.archiver.TarArchiver;
import com.mucommander.commons.file.archiver.ZipArchiver;
import com.mucommander.commons.io.BufferedRandomOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public abstract class Archiver {
    private static final boolean[] SUPPORTS_MANY_ENTRIES = new boolean[]{true, false, false, true, true, true};
    private static final int[] SINGLE_ENTRY_FORMATS = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] MANY_ENTRIES_FORMATS = new int[]{0, 3, 4, 5};
    private static final String[] FORMAT_NAMES = new String[]{"Zip", "Gzip", "Bzip2", "Tar", "Tar/Gzip", "Tar/Bzip2"};
    private static final String[] FORMAT_EXTENSIONS = new String[]{"zip", "gz", "bz2", "tar", "tar.gz", "tar.bz2"};
    protected OutputStream out;
    protected int format;

    Archiver(OutputStream out) {
        this.out = out;
    }

    private void setFormat(int format) {
        this.format = format;
    }

    public void setComment(String comment) {
    }

    protected String normalizePath(String entryPath, boolean isDirectory) {
        entryPath = entryPath.replace('\\', '/');
        if (isDirectory && !entryPath.endsWith("/")) {
            entryPath = entryPath + "/";
        }
        return entryPath;
    }

    public static Archiver getArchiver(AbstractFile file, int format) throws IOException, UnsupportedFileOperationException {
        OutputStream out = null;
        if (file.isFileOperationSupported(FileOperation.RANDOM_WRITE_FILE)) {
            try {
                if (file.exists()) {
                    file.delete();
                }
                out = new BufferedRandomOutputStream(file.getRandomAccessOutputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (out == null) {
            out = new BufferedOutputStream(file.getOutputStream());
        }
        return Archiver.getArchiver(out, format);
    }

    public static Archiver getArchiver(OutputStream out, int format) throws IOException {
        Archiver archiver;
        switch (format) {
            case 0: {
                archiver = new ZipArchiver(out);
                break;
            }
            case 1: {
                archiver = new SingleFileArchiver(new GZIPOutputStream(out));
                break;
            }
            case 2: {
                archiver = new SingleFileArchiver(Archiver.createBzip2OutputStream(out));
                break;
            }
            case 3: {
                archiver = new TarArchiver(out);
                break;
            }
            case 4: {
                archiver = new TarArchiver(new GZIPOutputStream(out));
                break;
            }
            case 5: {
                archiver = new TarArchiver(Archiver.createBzip2OutputStream(out));
                break;
            }
            default: {
                return null;
            }
        }
        super.setFormat(format);
        return archiver;
    }

    protected static OutputStream createBzip2OutputStream(OutputStream out) throws IOException {
        out.write(66);
        out.write(90);
        return new CBZip2OutputStream(out);
    }

    public static int[] getFormats(boolean manyEntries) {
        return manyEntries ? MANY_ENTRIES_FORMATS : SINGLE_ENTRY_FORMATS;
    }

    public static String getFormatName(int format) {
        return FORMAT_NAMES[format];
    }

    public static String getFormatExtension(int format) {
        return FORMAT_EXTENSIONS[format];
    }

    public static boolean formatSupportsComment(int format) {
        return format == 0;
    }

    public abstract OutputStream createEntry(String var1, FileAttributes var2) throws IOException;

    public abstract void close() throws IOException;
}

