/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.compat;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

class CompatURLConnection
extends URLConnection {
    protected AbstractFile file;

    public CompatURLConnection(URL url) throws IOException {
        super(url);
    }

    public CompatURLConnection(URL url, AbstractFile file) throws IOException {
        super(url);
        if (file != null) {
            this.file = file;
            this.connected = true;
        }
    }

    private void checkConnected() throws IOException {
        if (!this.connected) {
            this.connect();
        }
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.file = FileFactory.getFile(this.url.toString(), true);
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkConnected();
        return this.file.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkConnected();
        return this.file.getOutputStream();
    }

    public long getLastModified() {
        try {
            this.checkConnected();
            return this.file.getDate();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public long getDate() {
        return this.getLastModified();
    }

    public int getContentLength() {
        try {
            this.checkConnected();
            return (int)this.file.getSize();
        }
        catch (IOException e) {
            return -1;
        }
    }
}

