/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.connection;

import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.connection.ConnectionHandler;
import com.mucommander.commons.file.connection.ConnectionHandlerFactory;
import java.io.InterruptedIOException;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPool
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPool.class);
    private static ConnectionPool instance = new ConnectionPool();
    private static final Vector<ConnectionHandler> connectionHandlers = new Vector();
    private static Thread monitorThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ConnectionHandler getConnectionHandler(ConnectionHandlerFactory connectionHandlerFactory, FileURL url, boolean acquireLock) throws InterruptedIOException {
        ConnectionHandler connHandler;
        FileURL realm = url.getRealm();
        while (true) {
            Vector<ConnectionHandler> vector = connectionHandlers;
            synchronized (vector) {
                int nbConn = connectionHandlers.size();
                Credentials urlCredentials = url.getCredentials();
                int matchingConnHandlers = 0;
                for (int i = 0; i < nbConn; ++i) {
                    connHandler = ConnectionPool.getConnectionHandlerAt(i);
                    if (connHandler.equals(realm, urlCredentials)) {
                        ConnectionHandler connectionHandler = connHandler;
                        synchronized (connectionHandler) {
                            if (!(connHandler.isLocked() || acquireLock && !connHandler.acquireLock())) {
                                LOGGER.info("returning ConnectionHandler {}, realm = {}", connHandler, realm);
                                connHandler.updateLastActivityTimestamp();
                                return connHandler;
                            }
                        }
                    }
                    if (++matchingConnHandlers != 4) continue;
                    LOGGER.info("Maximum number of connection per realm reached, waiting for one to be removed or released...");
                    try {
                        connectionHandlers.wait();
                        break;
                    }
                    catch (InterruptedException e) {
                        LOGGER.info("Interrupted while waiting on a connection for {}", url, e);
                        throw new InterruptedIOException();
                    }
                }
                if (matchingConnHandlers != 4) break;
            }
        }
        {
            connHandler = connectionHandlerFactory.createConnectionHandler(url);
            if (acquireLock) {
                connHandler.acquireLock();
            }
            LOGGER.info("adding new ConnectionHandler {}, realm = {}", connHandler, connHandler.getRealm());
            connectionHandlers.insertElementAt(connHandler, 0);
            if (monitorThread == null) {
                LOGGER.info("starting monitor thread");
                monitorThread = new Thread(instance);
                monitorThread.start();
            }
            connHandler.updateLastActivityTimestamp();
            return connHandler;
        }
    }

    public static Vector<ConnectionHandler> getConnectionHandlersSnapshot() {
        return (Vector)connectionHandlers.clone();
    }

    private static ConnectionHandler getConnectionHandlerAt(int i) {
        return connectionHandlers.elementAt(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyConnectionHandlerLockReleased() {
        Vector<ConnectionHandler> vector = connectionHandlers;
        synchronized (vector) {
            connectionHandlers.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (monitorThread != null) {
            long now = System.currentTimeMillis();
            Vector<ConnectionHandler> vector = connectionHandlers;
            synchronized (vector) {
                for (int i = 0; i < connectionHandlers.size(); ++i) {
                    ConnectionHandler connHandler;
                    ConnectionHandler connectionHandler = connHandler = ConnectionPool.getConnectionHandlerAt(i);
                    synchronized (connectionHandler) {
                        if (!connHandler.isLocked()) {
                            if (!connHandler.isConnected()) {
                                LOGGER.info("Removing unconnected ConnectionHandler {}", connHandler);
                                connectionHandlers.removeElementAt(i);
                                connectionHandlers.notify();
                                continue;
                            }
                            long lastUsed = connHandler.getLastActivityTimestamp();
                            long closePeriod = connHandler.getCloseOnInactivityPeriod();
                            if (closePeriod != -1L && now - lastUsed > closePeriod * 1000L) {
                                LOGGER.info("Removing timed-out ConnectionHandler {}", connHandler);
                                connectionHandlers.removeElementAt(i);
                                connectionHandlers.notify();
                                new CloseConnectionThread(connHandler).start();
                                continue;
                            }
                            long keepAlivePeriod = connHandler.getKeepAlivePeriod();
                            if (keepAlivePeriod != -1L && now - Math.max(lastUsed, connHandler.getLastKeepAliveTimestamp()) > keepAlivePeriod * 1000L) {
                                connHandler.updateLastKeepAliveTimestamp();
                                new KeepAliveConnectionThread(connHandler).start();
                            }
                        }
                        continue;
                    }
                }
                if (connectionHandlers.size() == 0) {
                    LOGGER.info("No more ConnectionHandler, stopping monitor thread");
                    monitorThread = null;
                }
            }
            try {
                Thread.sleep(Math.max(0L, 1000L - (System.currentTimeMillis() - now)));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static class KeepAliveConnectionThread
    extends Thread {
        private final ConnectionHandler connHandler;

        private KeepAliveConnectionThread(ConnectionHandler connHandler) {
            this.connHandler = connHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LOGGER.info("keeping connection alive: {}", this.connHandler);
            ConnectionHandler connectionHandler = this.connHandler;
            synchronized (connectionHandler) {
                if (this.connHandler.isLocked()) {
                    return;
                }
                if (this.connHandler.isConnected()) {
                    this.connHandler.keepAlive();
                }
            }
        }
    }

    private static class CloseConnectionThread
    extends Thread {
        private ConnectionHandler connHandler;

        private CloseConnectionThread(ConnectionHandler connHandler) {
            this.connHandler = connHandler;
        }

        public void run() {
            if (this.connHandler.isConnected()) {
                LOGGER.info("Closing connection held by {}", this.connHandler);
                this.connHandler.closeConnection();
            }
        }
    }
}

