/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.filter;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.AbstractFileFilter;

public class AttributeFileFilter
extends AbstractFileFilter {
    private int attribute;

    public AttributeFileFilter(int attribute) {
        this(attribute, false);
    }

    public AttributeFileFilter(int attribute, boolean inverted) {
        super(inverted);
        this.attribute = attribute;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public boolean accept(AbstractFile file) {
        switch (this.attribute) {
            case 0: {
                return file.isDirectory();
            }
            case 1: {
                return !file.isDirectory();
            }
            case 2: {
                return file.isBrowsable();
            }
            case 3: {
                return file.isArchive();
            }
            case 4: {
                return file.isSymlink();
            }
            case 5: {
                return file.isHidden();
            }
            case 6: {
                return file.isRoot();
            }
        }
        return true;
    }
}

