/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.icon.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.icon.CacheableFileIconProvider;
import com.mucommander.commons.file.icon.CachedFileIconProvider;
import com.mucommander.commons.file.icon.IconCache;
import com.mucommander.commons.file.icon.LocalFileIconProvider;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.ResourceLoader;
import com.mucommander.commons.io.SilenceableOutputStream;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersion;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SwingFileIconProviderImpl
extends LocalFileIconProvider
implements CacheableFileIconProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingFileIconProviderImpl.class);
    private static FileSystemView fileSystemView;
    private static JFileChooser fileChooser;
    protected static IconCache directoryIconCache;
    protected static IconCache fileIconCache;
    protected static boolean initialized;
    protected static ImageIcon SYMLINK_OVERLAY_ICON;
    protected static SilenceableOutputStream errOut;

    SwingFileIconProviderImpl() {
    }

    static synchronized void checkInit() {
        if (initialized) {
            return;
        }
        if (OsFamilies.MAC_OS_X.isCurrent()) {
            fileChooser = new JFileChooser();
        } else {
            fileSystemView = FileSystemView.getFileSystemView();
        }
        URL uRL = ResourceLoader.getPackageResourceAsURL(SwingFileIconProviderImpl.class.getPackage(), "link.png");
        if (uRL == null) {
            throw new RuntimeException("Could not locate required symlink icon: link.png");
        }
        SYMLINK_OVERLAY_ICON = new ImageIcon(uRL);
        errOut = new SilenceableOutputStream(System.err, false);
        System.setErr(new PrintStream(errOut, true));
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Icon getSwingIcon(File javaIoFile) {
        try {
            if (fileSystemView != null) {
                errOut.setSilenced(true);
                Icon icon = fileSystemView.getSystemIcon(javaIoFile);
                return icon;
            }
            Icon icon = fileChooser.getIcon(javaIoFile);
            return icon;
        }
        catch (Exception e) {
            LOGGER.info("Caught exception while retrieving system icon for file {}", javaIoFile.getAbsolutePath(), e);
            Icon icon = null;
            return icon;
        }
        finally {
            if (fileSystemView != null) {
                errOut.setSilenced(false);
            }
        }
    }

    private static ImageIcon getSymlinkIcon(Icon targetFileIcon) {
        BufferedImage bi = new BufferedImage(targetFileIcon.getIconWidth(), targetFileIcon.getIconHeight(), 2);
        Graphics g = bi.getGraphics();
        targetFileIcon.paintIcon(null, g, 0, 0);
        SYMLINK_OVERLAY_ICON.paintIcon(null, g, 0, 0);
        return new ImageIcon(bi);
    }

    private static String getCheckedExtension(AbstractFile file) {
        String extension = file.getExtension();
        return extension == null ? "" : extension;
    }

    public boolean isCacheable(AbstractFile file, Dimension preferredResolution) {
        return !(file.getTopAncestor() instanceof LocalFile) && !file.isSymlink();
    }

    public Icon lookupCache(AbstractFile file, Dimension preferredResolution) {
        if (OsFamilies.MAC_OS_X.isCurrent() && !"file".equals(file.getURL().getScheme()) && file.isRoot()) {
            return SwingFileIconProviderImpl.getSwingIcon(new File("/Network"));
        }
        return (file.isDirectory() ? directoryIconCache : fileIconCache).get(SwingFileIconProviderImpl.getCheckedExtension(file));
    }

    public void addToCache(AbstractFile file, Icon icon, Dimension preferredResolution) {
        (file.isDirectory() ? directoryIconCache : fileIconCache).put(SwingFileIconProviderImpl.getCheckedExtension(file), icon);
    }

    public Icon getLocalFileIcon(LocalFile localFile, AbstractFile originalFile, Dimension preferredResolution) {
        SwingFileIconProviderImpl.checkInit();
        Icon icon = SwingFileIconProviderImpl.getSwingIcon((File)localFile.getUnderlyingFileObject());
        if ((!(originalFile.getTopAncestor() instanceof LocalFile) || OsFamilies.MAC_OS_X.isCurrent() && OsVersion.MAC_OS_X_10_5.isCurrent()) && originalFile.isSymlink()) {
            icon = SwingFileIconProviderImpl.getSymlinkIcon(icon);
        }
        return icon;
    }

    static {
        directoryIconCache = CachedFileIconProvider.createCache();
        fileIconCache = CachedFileIconProvider.createCache();
    }
}

