/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyFile
extends AbstractFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyFile.class);
    protected AbstractFile file;

    public ProxyFile(AbstractFile file) {
        super(file.getURL());
        this.file = file;
    }

    public AbstractFile getProxiedFile() {
        return this.file;
    }

    public long getDate() {
        return this.file.getDate();
    }

    public void changeDate(long lastModified) throws IOException, UnsupportedFileOperationException {
        this.file.changeDate(lastModified);
    }

    public long getSize() {
        return this.file.getSize();
    }

    public AbstractFile getParent() {
        return this.file.getParent();
    }

    public void setParent(AbstractFile parent) {
        this.file.setParent(parent);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException, UnsupportedFileOperationException {
        this.file.changePermission(access, permission, enabled);
    }

    public String getOwner() {
        return this.file.getOwner();
    }

    public boolean canGetOwner() {
        return this.file.canGetOwner();
    }

    public String getGroup() {
        return this.file.getGroup();
    }

    public boolean canGetGroup() {
        return this.file.canGetGroup();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isSymlink() {
        return this.file.isSymlink();
    }

    public AbstractFile[] ls() throws IOException, UnsupportedFileOperationException {
        return this.file.ls();
    }

    public void mkdir() throws IOException, UnsupportedFileOperationException {
        this.file.mkdir();
    }

    public InputStream getInputStream() throws IOException, UnsupportedFileOperationException {
        return this.file.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, UnsupportedFileOperationException {
        return this.file.getOutputStream();
    }

    public OutputStream getAppendOutputStream() throws IOException, UnsupportedFileOperationException {
        return this.file.getAppendOutputStream();
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException, UnsupportedFileOperationException {
        return this.file.getRandomAccessInputStream();
    }

    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException, UnsupportedFileOperationException {
        return this.file.getRandomAccessOutputStream();
    }

    public void delete() throws IOException, UnsupportedFileOperationException {
        this.file.delete();
    }

    public void copyRemotelyTo(AbstractFile destFile) throws IOException, UnsupportedFileOperationException {
        this.file.copyRemotelyTo(destFile);
    }

    public void renameTo(AbstractFile destFile) throws IOException, UnsupportedFileOperationException {
        this.file.renameTo(destFile);
    }

    public long getFreeSpace() throws IOException, UnsupportedFileOperationException {
        return this.file.getFreeSpace();
    }

    public long getTotalSpace() throws IOException, UnsupportedFileOperationException {
        return this.file.getTotalSpace();
    }

    public Object getUnderlyingFileObject() {
        return this.file.getUnderlyingFileObject();
    }

    public final boolean isFileOperationSupported(FileOperation fileOperation) {
        Class<?> clazz = this.getClass();
        Method method = fileOperation.getCorrespondingMethod(clazz);
        try {
            if (!clazz.getMethod(method.getName(), method.getParameterTypes()).getDeclaringClass().equals(ProxyFile.class)) {
                return AbstractFile.isFileOperationSupported(fileOperation, clazz);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Exception caught, this should not have happened", exception);
        }
        return this.file.isFileOperationSupported(fileOperation);
    }

    public FileURL getURL() {
        return this.file.getURL();
    }

    public URL getJavaNetURL() throws MalformedURLException {
        return this.file.getJavaNetURL();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getExtension() {
        return this.file.getExtension();
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public String getCanonicalPath() {
        return this.file.getCanonicalPath();
    }

    public AbstractFile getCanonicalFile() {
        return this.file.getCanonicalFile();
    }

    public String getSeparator() {
        return this.file.getSeparator();
    }

    public boolean isArchive() {
        return this.file.isArchive();
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public FilePermissions getPermissions() {
        return this.file.getPermissions();
    }

    public void changePermissions(int permissions) throws IOException, UnsupportedFileOperationException {
        this.file.changePermissions(permissions);
    }

    public PermissionBits getChangeablePermissions() {
        return this.file.getChangeablePermissions();
    }

    public String getPermissionsString() {
        return this.file.getPermissionsString();
    }

    public AbstractFile getRoot() {
        return this.file.getRoot();
    }

    public boolean isRoot() {
        return this.file.isRoot();
    }

    public AbstractFile getVolume() {
        return this.file.getVolume();
    }

    public InputStream getInputStream(long offset) throws IOException, UnsupportedFileOperationException {
        return this.file.getInputStream(offset);
    }

    public void copyStream(InputStream in, boolean append, long length) throws FileTransferException {
        this.file.copyStream(in, append, length);
    }

    public AbstractFile[] ls(FileFilter filter) throws IOException, UnsupportedFileOperationException {
        return this.file.ls(filter);
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException, UnsupportedFileOperationException {
        return this.file.ls(filter);
    }

    public void mkfile() throws IOException, UnsupportedFileOperationException {
        this.file.mkfile();
    }

    public void deleteRecursively() throws IOException, UnsupportedFileOperationException {
        this.file.deleteRecursively();
    }

    public boolean equals(Object f) {
        return this.file.equals(f);
    }

    public boolean equalsCanonical(Object f) {
        return this.file.equalsCanonical(f);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.file.toString();
    }
}

