/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.ar;

import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArArchiveEntryIterator
implements ArchiveEntryIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArArchiveEntryIterator.class);
    private InputStream in;
    private ArchiveEntry currentEntry;
    private byte[] gnuExtendedNames;

    ArArchiveEntryIterator(InputStream in) throws IOException {
        this.in = in;
        StreamUtils.skipFully(in, 8L);
    }

    ArchiveEntry getNextEntry() throws IOException {
        byte[] fileHeader = new byte[60];
        try {
            StreamUtils.readFully(this.in, fileHeader);
        }
        catch (IOException e) {
            return null;
        }
        try {
            String name = new String(fileHeader, 0, 16).trim();
            long date = name.equals("//") ? 0L : Long.parseLong(new String(fileHeader, 16, 12).trim()) * 1000L;
            long size = Long.parseLong(new String(fileHeader, 48, 10).trim());
            if (name.startsWith("#1/")) {
                int extendedNameLength = Integer.parseInt(name.substring(3, name.length()));
                name = new String(StreamUtils.readFully(this.in, new byte[extendedNameLength])).trim();
                size -= (long)extendedNameLength;
            } else {
                if (name.equals("//")) {
                    this.gnuExtendedNames = StreamUtils.readFully(this.in, new byte[(int)size]);
                    if (size % 2L != 0L) {
                        StreamUtils.skipFully(this.in, 1L);
                    }
                    return this.getNextEntry();
                }
                if (this.gnuExtendedNames != null && name.startsWith("/")) {
                    byte b;
                    int off = Integer.parseInt(name.substring(1, name.length()));
                    name = "";
                    while ((b = this.gnuExtendedNames[off++]) != 47) {
                        name = name + (char)b;
                    }
                }
            }
            return new ArchiveEntry(name, false, date, size, true);
        }
        catch (IOException e) {
            LOGGER.info("Caught IOException", e);
            throw e;
        }
        catch (Exception e2) {
            LOGGER.info("Caught Exception", e2);
            throw new IOException();
        }
    }

    public ArchiveEntry nextEntry() throws IOException {
        if (this.currentEntry != null) {
            long size = this.currentEntry.getSize();
            StreamUtils.skipFully(this.in, size + size % 2L);
        }
        this.currentEntry = this.getNextEntry();
        return this.currentEntry;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

