/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.bzip2;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.SingleArchiveEntryIterator;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bzip2ArchiveFile
extends AbstractROArchiveFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bzip2ArchiveFile.class);

    public Bzip2ArchiveFile(AbstractFile file) {
        super(file);
    }

    public ArchiveEntryIterator getEntryIterator() throws IOException {
        String extension = this.getExtension();
        String name = this.getName();
        if (extension != null) {
            if ((extension = extension.toLowerCase()).equals("tbz2")) {
                name = name.substring(0, name.length() - 4) + "tar";
            } else if (extension.equals("bz2")) {
                name = name.substring(0, name.length() - 4);
            }
        }
        return new SingleArchiveEntryIterator(new ArchiveEntry("/" + name, false, this.getDate(), -1L, true));
    }

    public InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException {
        try {
            InputStream in = this.getInputStream();
            in.read();
            in.read();
            return new CBZip2InputStream(new BufferedInputStream(in));
        }
        catch (Exception e) {
            LOGGER.info("Exception caught while creating CBZip2InputStream, throwing IOException", e);
            throw new IOException();
        }
    }
}

