/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.ftp;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.IndividualPermissionBits;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.connection.ConnectionHandler;
import com.mucommander.commons.file.connection.ConnectionHandlerFactory;
import com.mucommander.commons.file.connection.ConnectionPool;
import com.mucommander.commons.file.impl.ftp.FTPProtocolProvider;
import com.mucommander.commons.io.ByteUtils;
import com.mucommander.commons.io.FilteredOutputStream;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.ParserInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPFile
extends ProtocolFile
implements ConnectionHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FTPFile.class);
    private org.apache.commons.net.ftp.FTPFile file;
    private String absPath;
    private AbstractFile parent;
    private boolean parentValSet;
    private FilePermissions permissions;
    private boolean fileExists;
    private AbstractFile canonicalFile;
    private static final SimpleDateFormat SITE_UTIME_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");

    protected FTPFile(FileURL fileURL) throws IOException {
        this(fileURL, null);
    }

    protected FTPFile(FileURL fileURL, org.apache.commons.net.ftp.FTPFile file) throws IOException {
        super(fileURL);
        this.absPath = fileURL.getPath();
        if (file == null) {
            this.file = this.getFTPFile(fileURL);
            if (this.file == null) {
                String name = fileURL.getFilename();
                this.file = this.createFTPFile(name == null ? "" : name, false);
                this.fileExists = false;
            } else {
                this.fileExists = true;
            }
        } else {
            this.file = file;
            this.fileExists = true;
        }
        this.permissions = new FTPFilePermissions(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private org.apache.commons.net.ftp.FTPFile getFTPFile(FileURL fileURL) throws IOException {
        org.apache.commons.net.ftp.FTPFile[] files;
        FileURL parentURL = fileURL.getParent();
        LOGGER.trace("fileURL={} parent={}", fileURL, parentURL);
        if (parentURL == null) {
            return this.createFTPFile("/", true);
        }
        FTPConnectionHandler connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, fileURL, true);
        try {
            connHandler.checkConnection();
            files = FTPFile.listFiles(connHandler, parentURL.getPath());
        }
        finally {
            connHandler.releaseLock();
        }
        if (files == null || files.length == 0) {
            return null;
        }
        int nbFiles = files.length;
        String wantedName = fileURL.getFilename();
        for (int i = 0; i < nbFiles; ++i) {
            if (!files[i].getName().equalsIgnoreCase(wantedName)) continue;
            return files[i];
        }
        return null;
    }

    private org.apache.commons.net.ftp.FTPFile createFTPFile(String name, boolean isDirectory) {
        org.apache.commons.net.ftp.FTPFile file = new org.apache.commons.net.ftp.FTPFile();
        file.setName(name);
        file.setSize(0L);
        file.setTimestamp(Calendar.getInstance());
        file.setType(isDirectory ? 1 : 0);
        return file;
    }

    private static org.apache.commons.net.ftp.FTPFile[] listFiles(FTPConnectionHandler connHandler, String absPath) throws IOException, AuthException {
        try {
            connHandler.ftpClient.changeWorkingDirectory(absPath);
            org.apache.commons.net.ftp.FTPFile[] files = connHandler.ftpClient.listFiles();
            connHandler.checkServerReply();
            if (files == null) {
                return new org.apache.commons.net.ftp.FTPFile[0];
            }
            return files;
        }
        catch (ParserInitializationException e) {
            LOGGER.info("ParserInitializationException caught", e);
            throw new IOException();
        }
        catch (IOException e) {
            connHandler.checkSocketException(e);
            throw e;
        }
    }

    public ConnectionHandler createConnectionHandler(FileURL location) {
        return new FTPConnectionHandler(location);
    }

    public boolean isSymlink() {
        return this.file.isSymbolicLink();
    }

    public long getDate() {
        if (this.isSymlink()) {
            return ((org.apache.commons.net.ftp.FTPFile)this.getCanonicalFile().getUnderlyingFileObject()).getTimestamp().getTimeInMillis();
        }
        return this.file.getTimestamp().getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeDate(long lastModified) throws IOException, UnsupportedFileOperationException {
        ConnectionHandler connHandler = null;
        try {
            String sdate;
            connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
            if (!((FTPConnectionHandler)connHandler).utimeCommandSupported) {
                throw new UnsupportedFileOperationException(FileOperation.CHANGE_DATE);
            }
            connHandler.checkConnection();
            SimpleDateFormat simpleDateFormat = SITE_UTIME_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                sdate = SITE_UTIME_DATE_FORMAT.format(new Date(lastModified));
            }
            LOGGER.info("sending SITE UTIME {} {}", sdate, this.absPath);
            boolean success = ((FTPConnectionHandler)connHandler).ftpClient.sendSiteCommand("UTIME " + sdate + " " + this.absPath);
            LOGGER.info("server reply: {}", ((FTPConnectionHandler)connHandler).ftpClient.getReplyString());
            if (!success) {
                int replyCode = ((FTPConnectionHandler)connHandler).ftpClient.getReplyCode();
                if (replyCode == 500 || replyCode == 502 || replyCode == 504) {
                    LOGGER.info("marking UTIME command as unsupported");
                    ((FTPConnectionHandler)connHandler).utimeCommandSupported = false;
                }
                throw new IOException();
            }
        }
        catch (IOException e) {
            if (connHandler != null) {
                ((FTPConnectionHandler)connHandler).checkSocketException(e);
            }
            throw e;
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    public long getSize() {
        if (this.isSymlink()) {
            return ((org.apache.commons.net.ftp.FTPFile)this.getCanonicalFile().getUnderlyingFileObject()).getSize();
        }
        return this.file.getSize();
    }

    public AbstractFile getParent() {
        if (!this.parentValSet) {
            FileURL parentFileURL = this.fileURL.getParent();
            if (parentFileURL != null) {
                try {
                    this.parent = FileFactory.getFile(parentFileURL, null, this.createFTPFile(parentFileURL.getFilename(), true));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.parentValSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValSet = true;
    }

    public boolean exists() {
        return this.fileExists;
    }

    public FilePermissions getPermissions() {
        if (this.isSymlink()) {
            return this.getCanonicalFile().getAncestor(FTPFile.class).permissions;
        }
        return this.permissions;
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException, UnsupportedFileOperationException {
        this.changePermissions(ByteUtils.setBit(this.permissions.getIntValue(), permission << access * 3, enabled));
    }

    public PermissionBits getChangeablePermissions() {
        try {
            return ((FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, false)).chmodCommandSupported ? PermissionBits.FULL_PERMISSION_BITS : PermissionBits.EMPTY_PERMISSION_BITS;
        }
        catch (InterruptedIOException e) {
            return PermissionBits.EMPTY_PERMISSION_BITS;
        }
    }

    public String getOwner() {
        return this.file.getUser();
    }

    public boolean canGetOwner() {
        return true;
    }

    public String getGroup() {
        return this.file.getGroup();
    }

    public boolean canGetGroup() {
        return true;
    }

    public boolean isDirectory() {
        if (this.isSymlink()) {
            return ((org.apache.commons.net.ftp.FTPFile)this.getCanonicalFile().getUnderlyingFileObject()).isDirectory();
        }
        return this.file.isDirectory();
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(0L);
    }

    public OutputStream getOutputStream() throws IOException {
        return new FTPOutputStream(false);
    }

    public OutputStream getAppendOutputStream() throws IOException {
        return new FTPOutputStream(true);
    }

    @UnsupportedFileOperation
    public RandomAccessInputStream getRandomAccessInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_READ_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    public void delete() throws IOException {
        FTPConnectionHandler connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
        try {
            connHandler.checkConnection();
            if (this.isDirectory()) {
                connHandler.ftpClient.removeDirectory(this.absPath);
            } else {
                connHandler.ftpClient.deleteFile(this.absPath);
            }
            connHandler.checkServerReply();
        }
        catch (IOException e) {
            connHandler.checkSocketException(e);
            throw e;
        }
        finally {
            connHandler.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile[] ls() throws IOException {
        org.apache.commons.net.ftp.FTPFile[] files;
        FTPConnectionHandler connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
        try {
            connHandler.checkConnection();
            files = FTPFile.listFiles(connHandler, this.absPath);
        }
        finally {
            connHandler.releaseLock();
        }
        if (files == null || files.length == 0) {
            return new AbstractFile[0];
        }
        AbstractFile[] children = new AbstractFile[files.length];
        int nbFiles = files.length;
        int fileCount = 0;
        String parentPath = this.fileURL.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        for (int i = 0; i < nbFiles; ++i) {
            String childName;
            if (files[i] == null || (childName = files[i].getName()).equals(".") || childName.equals("..")) continue;
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(parentPath + childName);
            if (childName.equals(".") || childName.equals("..")) continue;
            AbstractFile child = FileFactory.getFile(childURL, (AbstractFile)this, files[i]);
            children[fileCount++] = child;
        }
        if (fileCount < nbFiles) {
            AbstractFile[] newChildren = new AbstractFile[fileCount];
            System.arraycopy(children, 0, newChildren, 0, fileCount);
            return newChildren;
        }
        return children;
    }

    public void mkdir() throws IOException {
        FTPConnectionHandler connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
        try {
            connHandler.checkConnection();
            connHandler.ftpClient.makeDirectory(this.absPath);
            connHandler.checkServerReply();
            this.file.setType(1);
            this.fileExists = true;
        }
        catch (IOException e) {
            connHandler.checkSocketException(e);
            throw e;
        }
        finally {
            connHandler.releaseLock();
        }
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    public Object getUnderlyingFileObject() {
        return this.file;
    }

    public void changePermissions(int permissions) throws IOException, UnsupportedFileOperationException {
        ConnectionHandler connHandler = null;
        try {
            connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
            if (!((FTPConnectionHandler)connHandler).chmodCommandSupported) {
                throw new UnsupportedFileOperationException(FileOperation.CHANGE_PERMISSION);
            }
            connHandler.checkConnection();
            LOGGER.info("sending SITE CHMOD {} {}", Integer.toOctalString(permissions), this.absPath);
            boolean success = ((FTPConnectionHandler)connHandler).ftpClient.sendSiteCommand("CHMOD " + Integer.toOctalString(permissions) + " " + this.absPath);
            LOGGER.info("server reply: {}", ((FTPConnectionHandler)connHandler).ftpClient.getReplyString());
            if (!success) {
                int replyCode = ((FTPConnectionHandler)connHandler).ftpClient.getReplyCode();
                if (replyCode == 500 || replyCode == 502 || replyCode == 504) {
                    LOGGER.info("marking CHMOD command as unsupported");
                    ((FTPConnectionHandler)connHandler).chmodCommandSupported = false;
                }
                throw new IOException();
            }
        }
        catch (IOException e) {
            if (connHandler != null) {
                ((FTPConnectionHandler)connHandler).checkSocketException(e);
            }
            throw e;
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    public void renameTo(AbstractFile destFile) throws IOException {
        this.checkRenamePrerequisites(destFile, false, false);
        ConnectionHandler connHandler = null;
        try {
            connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(this, this.fileURL, true);
            connHandler.checkConnection();
            if (!((FTPConnectionHandler)connHandler).ftpClient.rename(this.absPath, destFile.getURL().getPath())) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            if (connHandler != null) {
                ((FTPConnectionHandler)connHandler).checkSocketException(e);
            }
            throw e;
        }
        finally {
            if (connHandler != null) {
                connHandler.releaseLock();
            }
        }
    }

    public InputStream getInputStream(long offset) throws IOException {
        return new FTPInputStream(offset);
    }

    public AbstractFile getCanonicalFile() {
        if (!this.isSymlink()) {
            return this;
        }
        if (this.canonicalFile == null) {
            String symlinkTargetPath = this.file.getLink();
            if (!symlinkTargetPath.startsWith("/")) {
                String parentPath = this.fileURL.getParent().getPath();
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                symlinkTargetPath = parentPath + symlinkTargetPath;
            }
            FileURL canonicalURL = (FileURL)this.fileURL.clone();
            canonicalURL.setPath(symlinkTargetPath);
            this.canonicalFile = FileFactory.getFile(canonicalURL);
        }
        return this.canonicalFile;
    }

    private static class FTPFilePermissions
    extends IndividualPermissionBits
    implements FilePermissions {
        private org.apache.commons.net.ftp.FTPFile file;

        public FTPFilePermissions(org.apache.commons.net.ftp.FTPFile file) {
            this.file = file;
        }

        public boolean getBitValue(int access, int type) {
            int fPermission;
            int fAccess;
            if (access == 2) {
                fAccess = 0;
            } else if (access == 1) {
                fAccess = 1;
            } else if (access == 0) {
                fAccess = 2;
            } else {
                return false;
            }
            if (type == 4) {
                fPermission = 0;
            } else if (type == 2) {
                fPermission = 1;
            } else if (type == 1) {
                fPermission = 2;
            } else {
                return false;
            }
            return this.file.hasPermission(fAccess, fPermission);
        }

        public PermissionBits getMask() {
            return FULL_PERMISSION_BITS;
        }
    }

    private static class FTPConnectionHandler
    extends ConnectionHandler {
        private FTPClient ftpClient;
        private boolean passiveMode;
        private String encoding;
        private int nbConnectionRetries;
        private int connectionRetryDelay;
        private boolean utimeCommandSupported = true;
        private boolean chmodCommandSupported = true;

        private FTPConnectionHandler(FileURL location) {
            super(location);
            String prop;
            String passiveModeProperty = location.getProperty("passiveMode");
            this.passiveMode = passiveModeProperty == null || !passiveModeProperty.equals("false");
            this.encoding = location.getProperty("encoding");
            if (this.encoding == null || this.encoding.equals("")) {
                this.encoding = "UTF-8";
            }
            if ((prop = location.getProperty("nbConnectionRetries")) == null) {
                this.nbConnectionRetries = 0;
            } else {
                try {
                    this.nbConnectionRetries = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    this.nbConnectionRetries = 0;
                }
            }
            prop = location.getProperty("connectionRetryDelay");
            if (prop == null) {
                this.connectionRetryDelay = 15;
            } else {
                try {
                    this.connectionRetryDelay = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    this.connectionRetryDelay = 15;
                }
            }
            this.setKeepAlivePeriod(60L);
        }

        private void checkServerReply() throws IOException, AuthException {
            int replyCode = this.ftpClient.getReplyCode();
            LOGGER.trace("server reply=" + this.ftpClient.getReplyString());
            if (replyCode == 421) {
                this.closeConnection();
            }
            if (!FTPReply.isPositiveCompletion(replyCode)) {
                if (replyCode == 503 || replyCode == 331 || replyCode == 530) {
                    this.throwAuthException(this.ftpClient.getReplyString());
                } else {
                    throw new IOException(this.ftpClient.getReplyString());
                }
            }
        }

        private void checkSocketException(IOException e) {
            if ((e instanceof FTPConnectionClosedException || e instanceof SocketException || e instanceof SocketTimeoutException) && this.isConnected()) {
                LOGGER.info("socket exception detected, closing connection", e);
                this.closeConnection();
            }
        }

        public void startConnection() throws IOException {
            LOGGER.info("connecting to {}", this.getRealm().getHost());
            this.ftpClient = new FTPClient();
            int retriesLeft = this.nbConnectionRetries;
            int retryDelay = this.connectionRetryDelay * 1000;
            while (true) {
                try {
                    FileURL realm = this.getRealm();
                    int port = realm.getPort();
                    LOGGER.info("custom port={}", port);
                    if (port != -1) {
                        this.ftpClient.setDefaultPort(port);
                    }
                    LOGGER.info("encoding={}", this.encoding);
                    this.ftpClient.setControlEncoding(this.encoding);
                    this.ftpClient.connect(realm.getHost());
                    this.checkServerReply();
                    Credentials credentials = this.getCredentials();
                    LOGGER.info("fileURL={} credentials={}", realm.toString(true), credentials);
                    if (credentials == null) {
                        this.throwAuthException(null);
                    }
                    this.ftpClient.login(credentials.getLogin(), credentials.getPassword());
                    this.checkServerReply();
                    LOGGER.info("passiveMode={}", this.passiveMode);
                    if (this.passiveMode) {
                        this.ftpClient.enterLocalPassiveMode();
                    } else {
                        this.ftpClient.enterLocalActiveMode();
                    }
                    this.ftpClient.setFileType(2);
                    this.ftpClient.setListHiddenFiles(FTPProtocolProvider.getForceHiddenFilesListing());
                    if (!this.encoding.equalsIgnoreCase("UTF-8")) break;
                    this.ftpClient.sendCommand("OPTS UTF8 ON");
                }
                catch (IOException e) {
                    int replyCode = this.ftpClient.getReplyCode();
                    if (!this.ftpClient.isConnected() || FTPReply.isNegativeTransient(replyCode)) {
                        LOGGER.info((!this.ftpClient.isConnected() ? "Connection error" : "Temporary server error (" + replyCode + ")") + ", retries left=" + retriesLeft, e);
                        if (retriesLeft > 0) {
                            --retriesLeft;
                            if (retryDelay <= 0) continue;
                            LOGGER.info("waiting {} ms before retrying to connect", retryDelay);
                            try {
                                Thread.sleep(retryDelay);
                            }
                            catch (InterruptedException e2) {}
                            continue;
                        }
                    }
                    if (this.ftpClient.isConnected()) {
                        try {
                            this.ftpClient.disconnect();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                break;
            }
        }

        public boolean isConnected() {
            return this.ftpClient != null && this.ftpClient.isConnected();
        }

        public void closeConnection() {
            if (this.ftpClient != null) {
                try {
                    this.ftpClient.logout();
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    this.ftpClient.disconnect();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.ftpClient = null;
            }
        }

        public void keepAlive() {
            if (this.ftpClient != null) {
                try {
                    this.ftpClient.sendNoOp();
                }
                catch (IOException e) {
                    this.checkSocketException(e);
                }
            }
        }
    }

    private class FTPOutputStream
    extends FilteredOutputStream {
        private FTPConnectionHandler connHandler;
        private boolean isClosed;

        private FTPOutputStream(boolean append) throws IOException {
            super(null);
            try {
                this.connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(FTPFile.this, FTPFile.this.fileURL, true);
                this.connHandler.checkConnection();
                this.out = append ? this.connHandler.ftpClient.appendFileStream(FTPFile.this.absPath) : this.connHandler.ftpClient.storeFileStream(FTPFile.this.absPath);
                if (this.out == null) {
                    throw new IOException();
                }
            }
            catch (IOException e) {
                if (this.connHandler != null) {
                    this.connHandler.checkSocketException(e);
                    this.connHandler.releaseLock();
                }
                throw e;
            }
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                super.close();
                LOGGER.trace("complete pending commands");
                this.connHandler.ftpClient.completePendingCommand();
                LOGGER.trace("commands completed");
            }
            catch (IOException e) {
                LOGGER.info("exception in completePendingCommands()", e);
                this.connHandler.checkSocketException(e);
                throw e;
            }
            finally {
                this.connHandler.releaseLock();
            }
        }
    }

    private class FTPInputStream
    extends FilterInputStream {
        private FTPConnectionHandler connHandler;
        private boolean isClosed;

        private FTPInputStream(long skipBytes) throws IOException {
            super(null);
            try {
                this.connHandler = (FTPConnectionHandler)ConnectionPool.getConnectionHandler(FTPFile.this, FTPFile.this.fileURL, true);
                this.connHandler.checkConnection();
                if (skipBytes > 0L) {
                    this.connHandler.ftpClient.setRestartOffset(skipBytes);
                }
                this.in = this.connHandler.ftpClient.retrieveFileStream(FTPFile.this.absPath);
                if (this.in == null) {
                    if (skipBytes > 0L) {
                        this.connHandler.ftpClient.setRestartOffset(0L);
                    }
                    throw new IOException();
                }
            }
            catch (IOException e) {
                if (this.connHandler != null) {
                    this.connHandler.checkSocketException(e);
                    this.connHandler.releaseLock();
                }
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                super.close();
                LOGGER.info("complete pending commands");
                this.connHandler.ftpClient.completePendingCommand();
                LOGGER.info("commands completed");
            }
            catch (IOException e) {
                LOGGER.info("exception in completePendingCommands()", e);
                this.connHandler.checkSocketException(e);
            }
            finally {
                this.connHandler.releaseLock();
            }
        }
    }
}

