/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.hadoop;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.SyncedFileAttributes;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.io.ByteCounter;
import com.mucommander.commons.io.ByteUtils;
import com.mucommander.commons.io.CounterOutputStream;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HadoopFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopFile.class);
    private FileSystem fs;
    private Path path;
    private HadoopFileAttributes fileAttributes;
    private AbstractFile parent;
    private boolean parentValSet;
    private boolean isWriting;
    protected static final Configuration DEFAULT_CONFIGURATION = new Configuration();

    protected HadoopFile(FileURL url) throws IOException {
        this(url, null, null);
    }

    protected HadoopFile(FileURL url, FileSystem fs, FileStatus fileStatus) throws IOException {
        super(url);
        if (fs == null) {
            try {
                this.fs = this.getHadoopFileSystem(url);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        } else {
            this.fs = fs;
        }
        if (fileStatus == null) {
            this.path = new Path(this.fileURL.getPath());
            this.fileAttributes = new HadoopFileAttributes();
        } else {
            this.fileAttributes = new HadoopFileAttributes(fileStatus);
            this.path = fileStatus.getPath();
        }
    }

    private OutputStream getOutputStream(boolean append) throws IOException {
        CounterOutputStream out = new CounterOutputStream(append ? this.fs.append(this.path) : this.fs.create(this.path, true), new ByteCounter(){

            public synchronized void add(long nbBytes) {
                HadoopFile.this.fileAttributes.addToSize(nbBytes);
                HadoopFile.this.fileAttributes.setDate(System.currentTimeMillis());
            }
        }){

            public void close() throws IOException {
                super.close();
                HadoopFile.this.isWriting = false;
            }
        };
        this.fileAttributes.setExists(true);
        this.fileAttributes.setDate(System.currentTimeMillis());
        this.fileAttributes.setSize(0L);
        this.isWriting = true;
        return out;
    }

    public AbstractFile getParent() {
        if (!this.parentValSet) {
            FileURL parentFileURL = this.fileURL.getParent();
            if (parentFileURL != null) {
                this.parent = FileFactory.getFile(this.fileURL.getParent());
            }
            this.parentValSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValSet = true;
    }

    public Object getUnderlyingFileObject() {
        return this.fileAttributes;
    }

    public boolean exists() {
        return this.fileAttributes.exists();
    }

    public boolean isDirectory() {
        return this.fileAttributes.isDirectory();
    }

    public boolean isSymlink() {
        return false;
    }

    public long getDate() {
        return this.fileAttributes.getDate();
    }

    public long getSize() {
        return this.fileAttributes.getSize();
    }

    public PermissionBits getChangeablePermissions() {
        return FilePermissions.FULL_PERMISSION_BITS;
    }

    public FilePermissions getPermissions() {
        return this.fileAttributes.getPermissions();
    }

    public String getOwner() {
        return this.fileAttributes.getOwner();
    }

    public boolean canGetOwner() {
        return true;
    }

    public String getGroup() {
        return this.fileAttributes.getGroup();
    }

    public boolean canGetGroup() {
        return true;
    }

    public void mkdir() throws IOException {
        if (this.exists() || !this.fs.mkdirs(this.path)) {
            throw new IOException();
        }
        this.fileAttributes.setExists(true);
        this.fileAttributes.setDirectory(true);
        this.fileAttributes.setDate(System.currentTimeMillis());
        this.fileAttributes.setSize(0L);
    }

    public void delete() throws IOException {
        if (!this.fs.delete(this.path, false)) {
            throw new IOException();
        }
        this.fileAttributes.setExists(false);
        this.fileAttributes.setDirectory(false);
        this.fileAttributes.setSize(0L);
    }

    public void renameTo(AbstractFile destFile) throws IOException {
        this.checkRenamePrerequisites(destFile, false, false);
        if (destFile.exists()) {
            destFile.delete();
        }
        if (!this.fs.rename(this.path, ((HadoopFile)destFile).path)) {
            throw new IOException();
        }
        ((HadoopFileAttributes)destFile.getUnderlyingFileObject()).fetchAttributes();
        this.fileAttributes.setExists(false);
        this.fileAttributes.setDirectory(false);
        this.fileAttributes.setSize(0L);
    }

    public void changeDate(long lastModified) throws IOException {
        this.fs.setTimes(this.path, lastModified, lastModified);
        this.fileAttributes.setDate(lastModified);
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException {
        this.changePermissions(ByteUtils.setBit(this.getPermissions().getIntValue(), permission << access * 3, enabled));
    }

    public InputStream getInputStream() throws IOException {
        return this.fs.open(this.path);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(false);
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new HadoopRandomAccessInputStream(this.fs.open(this.path), this.getSize());
    }

    public AbstractFile[] ls() throws IOException {
        return this.ls(null);
    }

    @UnsupportedFileOperation
    public OutputStream getAppendOutputStream() throws IOException {
        throw new UnsupportedFileOperationException(FileOperation.APPEND_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException, UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException {
        if (!this.exists() || !this.isDirectory()) {
            throw new IOException();
        }
        FileStatus[] statuses = filter == null ? this.fs.listStatus(this.path) : this.fs.listStatus(this.path, new HadoopFilenameFilter(filter));
        int nbChildren = statuses == null ? 0 : statuses.length;
        AbstractFile[] children = new AbstractFile[nbChildren];
        String parentPath = this.fileURL.getPath();
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        for (int i = 0; i < nbChildren; ++i) {
            FileStatus childStatus = statuses[i];
            FileURL childURL = (FileURL)this.fileURL.clone();
            childURL.setPath(parentPath + childStatus.getPath().getName());
            children[i] = FileFactory.getFile(childURL, (AbstractFile)this, this.fs, childStatus);
        }
        return children;
    }

    public void changePermissions(int permissions) throws IOException, UnsupportedFileOperationException {
        this.fs.setPermission(this.path, new FsPermission((short)permissions));
        this.fileAttributes.setPermissions(new SimpleFilePermissions(permissions));
    }

    protected abstract FileSystem getHadoopFileSystem(FileURL var1) throws IOException;

    protected abstract void setDefaultFileAttributes(FileURL var1, HadoopFileAttributes var2);

    private static class HadoopFilenameFilter
    implements PathFilter {
        private FilenameFilter filenameFilter;

        private HadoopFilenameFilter(FilenameFilter filenameFilter) {
            this.filenameFilter = filenameFilter;
        }

        public boolean accept(Path path) {
            return this.filenameFilter.accept(path.getName());
        }
    }

    private static class HadoopRandomAccessInputStream
    extends RandomAccessInputStream {
        private FSDataInputStream in;
        private long length;

        private HadoopRandomAccessInputStream(FSDataInputStream in, long length) {
            this.in = in;
            this.length = length;
        }

        public long getOffset() throws IOException {
            return this.in.getPos();
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public void seek(long offset) throws IOException {
            this.in.seek(offset);
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        public void close() throws IOException {
        }
    }

    class HadoopFileAttributes
    extends SyncedFileAttributes {
        private HadoopFileAttributes() throws AuthException {
            super(60000L, false);
            this.fetchAttributes();
            this.updateExpirationDate();
        }

        private HadoopFileAttributes(FileStatus fileStatus) {
            super(60000L, false);
            this.setAttributes(fileStatus);
            this.setExists(true);
            this.updateExpirationDate();
        }

        private void fetchAttributes() throws AuthException {
            block3: {
                if (HadoopFile.this.isWriting) {
                    return;
                }
                try {
                    this.setAttributes(HadoopFile.this.fs.getFileStatus(HadoopFile.this.path));
                    this.setExists(true);
                }
                catch (IOException e) {
                    this.setExists(false);
                    HadoopFile.this.setDefaultFileAttributes(HadoopFile.this.getURL(), this);
                    if (!(e instanceof AuthException)) break block3;
                    throw (AuthException)e;
                }
            }
        }

        private void setAttributes(FileStatus fileStatus) {
            this.setDirectory(fileStatus.isDir());
            this.setDate(fileStatus.getModificationTime());
            this.setSize(fileStatus.getLen());
            this.setPermissions(new SimpleFilePermissions(fileStatus.getPermission().toShort() & 0x1FF));
            this.setOwner(fileStatus.getOwner());
            this.setGroup(fileStatus.getGroup());
        }

        private void addToSize(long increment) {
            this.setSize(this.getSize() + increment);
        }

        public void updateAttributes() {
            try {
                this.fetchAttributes();
            }
            catch (Exception e) {
                LOGGER.info("Failed to update attributes", e);
            }
        }
    }
}

