/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.http;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.MimeTypes;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.SimpleFileAttributes;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.io.BlockRandomInputStream;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.io.base64.Base64Encoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPFile.class);
    private URL url;
    private SimpleFileAttributes attributes;
    private boolean resolve;
    private boolean fileResolved;
    private boolean parentValSet;
    protected AbstractFile parent;
    private static final FilePermissions PERMISSIONS = new SimpleFilePermissions(256, 448);
    public static final String USER_AGENT = "muCommander-file-API (Java " + System.getProperty("java.vm.version") + "; " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")";
    private static final Pattern linkAttributePatternSQ = Pattern.compile("(src|href|SRC|HREF)=\\'.*?\\'");
    private static final Pattern linkAttributePatternDQ = Pattern.compile("(src|href|SRC|HREF)=\\\".*?\\\"");

    protected HTTPFile(FileURL fileURL) throws IOException {
        this(fileURL, new URL(fileURL.toString(false)));
    }

    protected HTTPFile(FileURL fileURL, URL url) throws IOException {
        super(fileURL);
        String mimeType;
        String scheme = fileURL.getScheme().toLowerCase();
        if (!scheme.equals("http") && !scheme.equals("https") || fileURL.getHost() == null) {
            throw new IOException();
        }
        this.url = url;
        this.attributes = HTTPFile.getDefaultAttributes();
        String filename = fileURL.getFilename();
        if (filename == null || fileURL.getPath().endsWith("/") || fileURL.getQuery() != null || (mimeType = MimeTypes.getMimeType(this)) != null && this.isParsableMimeType(mimeType)) {
            this.attributes.setDirectory(true);
            this.resolve = false;
        } else {
            this.resolve = true;
        }
    }

    private static SimpleFileAttributes getDefaultAttributes() {
        SimpleFileAttributes attributes = new SimpleFileAttributes();
        attributes.setDate(System.currentTimeMillis());
        attributes.setSize(-1L);
        attributes.setPermissions(PERMISSIONS);
        return attributes;
    }

    private boolean isParsableMimeType(String mimeType) {
        return mimeType != null && (mimeType.startsWith("text/html") || mimeType.startsWith("application/xhtml+xml") || mimeType.startsWith("application/xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveFile() throws IOException {
        try {
            LOGGER.info("Resolving {}", this.url);
            HttpURLConnection conn = this.getHttpURLConnection(this.url);
            conn.setRequestMethod("HEAD");
            conn.connect();
            this.checkHTTPResponse(conn);
            long date = conn.getLastModified();
            if (date == 0L && (date = conn.getDate()) == 0L) {
                date = System.currentTimeMillis();
            }
            this.attributes.setDate(date);
            this.attributes.setSize(conn.getContentLength());
            String contentType = conn.getContentType();
            if (this.isParsableMimeType(contentType)) {
                this.attributes.setDirectory(true);
            }
            this.attributes.setExists(true);
        }
        catch (IOException e) {
            LOGGER.info("Failed to resolve file {}", this.url, e);
        }
        finally {
            this.fileResolved = true;
        }
    }

    private HttpURLConnection getHttpURLConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Credentials credentials = this.fileURL.getCredentials();
        if (credentials != null) {
            conn.setRequestProperty("Authorization", "Basic " + Base64Encoder.encode(credentials.getLogin() + ":" + credentials.getPassword()));
        }
        conn.setRequestProperty("User-Agent", USER_AGENT);
        return conn;
    }

    private void checkHTTPResponse(HttpURLConnection conn) throws AuthException, IOException {
        int responseCode = conn.getResponseCode();
        LOGGER.info("response code = {}", responseCode);
        if (responseCode == 401) {
            throw new AuthException(this.fileURL, conn.getResponseMessage());
        }
        if (responseCode < 200 || responseCode >= 400) {
            throw new IOException(conn.getResponseMessage());
        }
    }

    private void checkResolveFile() {
        if (this.resolve && !this.fileResolved) {
            try {
                this.resolveFile();
            }
            catch (IOException e) {
                LOGGER.info("Failed to resolve {}", this.url, e);
            }
        }
    }

    public long getDate() {
        this.checkResolveFile();
        return this.attributes.getDate();
    }

    @UnsupportedFileOperation
    public void changeDate(long date) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_DATE);
    }

    public long getSize() {
        this.checkResolveFile();
        return this.attributes.getSize();
    }

    public AbstractFile getParent() {
        if (!this.parentValSet) {
            FileURL parentURL = this.fileURL.getParent();
            this.parent = parentURL == null ? null : FileFactory.getFile(parentURL);
            this.parentValSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValSet = true;
    }

    public boolean exists() {
        if (!this.fileResolved) {
            try {
                this.resolveFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.attributes.exists();
    }

    public FilePermissions getPermissions() {
        return this.attributes.getPermissions();
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.EMPTY_PERMISSION_BITS;
    }

    @UnsupportedFileOperation
    public void changePermission(int access, int permission, boolean enabled) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_PERMISSION);
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }

    public boolean isDirectory() {
        this.checkResolveFile();
        return this.attributes.isDirectory();
    }

    public boolean isSymlink() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        HttpURLConnection conn = this.getHttpURLConnection(this.url);
        conn.connect();
        this.checkHTTPResponse(conn);
        return conn.getInputStream();
    }

    @UnsupportedFileOperation
    public OutputStream getOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.WRITE_FILE);
    }

    @UnsupportedFileOperation
    public OutputStream getAppendOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.APPEND_FILE);
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        return new HTTPRandomAccessInputStream();
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    @UnsupportedFileOperation
    public void delete() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.DELETE);
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public void renameTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RENAME);
    }

    @UnsupportedFileOperation
    public void mkdir() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CREATE_DIRECTORY);
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    public Object getUnderlyingFileObject() {
        return this.url;
    }

    public AbstractFile[] ls() throws IOException {
        BufferedReader br = null;
        try {
            String line;
            InputStreamReader ir;
            HttpURLConnection conn;
            URL contextURL = this.url;
            while (true) {
                conn = this.getHttpURLConnection(contextURL);
                conn.setInstanceFollowRedirects(false);
                conn.connect();
                this.checkHTTPResponse(conn);
                int responseCode = conn.getResponseCode();
                String locationHeader = conn.getHeaderField("Location");
                if (responseCode < 300 || responseCode >= 400 || locationHeader == null) break;
                LOGGER.info("Location header = {}", conn.getHeaderField("Location"));
                contextURL = new URL(contextURL, locationHeader);
            }
            String contentType = conn.getContentType();
            if (contentType == null || !this.isParsableMimeType(contentType)) {
                throw new IOException("Document cannot be parsed (not HTML or XHTML)");
            }
            String enc = null;
            int pos = contentType.indexOf("charset");
            if (pos != -1 || (pos = contentType.indexOf("Charset")) != -1) {
                StringTokenizer st = new StringTokenizer(contentType.substring(pos, contentType.length()));
                enc = st.nextToken();
            }
            InputStream in = conn.getInputStream();
            if (enc == null) {
                ir = new InputStreamReader(in);
            } else {
                try {
                    ir = new InputStreamReader(in, enc);
                }
                catch (UnsupportedEncodingException e) {
                    ir = new InputStreamReader(in);
                }
            }
            br = new BufferedReader(ir);
            Vector<AbstractFile> children = new Vector<AbstractFile>();
            TreeSet<String> childrenURL = new TreeSet<String>();
            Credentials credentials = this.fileURL.getCredentials();
            String parentPath = this.fileURL.getPath();
            if (!parentPath.endsWith("/")) {
                parentPath = parentPath + "/";
            }
            String parentHost = this.fileURL.getHost();
            FileURL tempChildURL = (FileURL)this.fileURL.clone();
            block14: while ((line = br.readLine()) != null) {
                Pattern pattern = linkAttributePatternSQ;
                while (true) {
                    Matcher matcher = pattern.matcher(line);
                    while (matcher.find()) {
                        String match = matcher.group();
                        String link = match.substring(match.indexOf(pattern == linkAttributePatternSQ ? 39 : 34) + 1, match.length() - 1);
                        if (link.startsWith("mailto") || link.startsWith("MAILTO") || link.startsWith("#") || link.startsWith("javascript:") || childrenURL.contains(link)) continue;
                        try {
                            LOGGER.trace("creating child {} context={}", link, contextURL);
                            URL childURL = new URL(contextURL, link);
                            FileURL childFileURL = FileURL.getFileURL(childURL.toExternalForm());
                            if (parentHost.equals(childFileURL.getHost())) {
                                childFileURL.setCredentials(credentials);
                            }
                            children.add(FileFactory.getFile(childFileURL, null, childURL, childURL.toString()));
                            childrenURL.add(link);
                        }
                        catch (IOException e) {
                            LOGGER.info("Cannot create child: {}", e);
                        }
                    }
                    if (pattern == linkAttributePatternDQ) continue block14;
                    pattern = linkAttributePatternDQ;
                }
            }
            AbstractFile[] childrenArray = new AbstractFile[children.size()];
            children.toArray(childrenArray);
            AbstractFile[] abstractFileArray = childrenArray;
            return abstractFileArray;
        }
        catch (Exception e) {
            LOGGER.info("Exception caught while parsing HTML, throwing IOException", e);
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException();
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public boolean isHidden() {
        return false;
    }

    public String getName() {
        try {
            return URLDecoder.decode(super.getName(), "utf-8");
        }
        catch (Exception e) {
            return super.getName();
        }
    }

    public InputStream getInputStream(long offset) throws IOException {
        HttpURLConnection conn = this.getHttpURLConnection(this.url);
        conn.setRequestProperty("Range", "bytes=" + offset + "-");
        conn.connect();
        this.checkHTTPResponse(conn);
        return conn.getInputStream();
    }

    private class HTTPRandomAccessInputStream
    extends BlockRandomInputStream {
        private long length;

        private HTTPRandomAccessInputStream() throws IOException {
            super(1024);
            if (!HTTPFile.this.fileResolved) {
                HTTPFile.this.resolveFile();
            }
            this.length = HTTPFile.this.getSize();
            if (this.length == -1L) {
                throw new IOException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int readBlock(long fileOffset, byte[] block, int blockLen) throws IOException {
            HttpURLConnection conn = HTTPFile.this.getHttpURLConnection(HTTPFile.this.url);
            conn.setRequestProperty("Range", "bytes=" + fileOffset + "-" + Math.min(fileOffset + (long)blockLen, this.length - 1L));
            conn.connect();
            HTTPFile.this.checkHTTPResponse(conn);
            InputStream in = conn.getInputStream();
            try {
                int totalRead;
                int read;
                for (totalRead = 0; totalRead < blockLen && (read = in.read(block, totalRead, blockLen - totalRead)) != -1; totalRead += read) {
                }
                int n = totalRead;
                return n;
            }
            finally {
                in.close();
            }
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public void close() throws IOException {
        }
    }
}

