/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.iso;

import com.mucommander.commons.file.impl.iso.IsoArchiveEntry;
import com.mucommander.commons.file.impl.iso.IsoUtil;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.io.InputStream;

class IsoEntryInputStream
extends InputStream {
    private RandomAccessInputStream rais;
    private int pos;
    private long size;
    private int sectSize;
    private boolean audio;

    IsoEntryInputStream(RandomAccessInputStream rais, IsoArchiveEntry entry) throws IOException {
        this.rais = rais;
        this.size = entry.getSize();
        this.pos = 0;
        this.sectSize = entry.getSectSize();
        this.audio = entry.getAudio();
        rais.seek(IsoUtil.offsetInSector(entry.getIndex(), this.sectSize, this.audio) + entry.getShiftOffset());
    }

    public int read() throws IOException {
        return this.rais.read();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int toRead = len;
        int available = this.available();
        if (toRead > available) {
            toRead = available;
        }
        if (available == 0) {
            return -1;
        }
        int cur = off;
        int before = this.pos;
        int skip = 0;
        if (this.audio && this.pos == 0) {
            IsoUtil.toArray(1179011410, b, 0);
            IsoUtil.toArray((int)this.size - 8, b, 4);
            IsoUtil.toArray(1163280727, b, 8);
            IsoUtil.toArray(544501094, b, 12);
            b[16] = 16;
            IsoUtil.toArray(131073, b, 20);
            IsoUtil.toArray(44100, b, 24);
            IsoUtil.toArray(176400, b, 28);
            IsoUtil.toArray(0x100004, b, 32);
            IsoUtil.toArray(1635017060, b, 36);
            IsoUtil.toArray((int)this.size - 44, b, 40);
            cur = 44;
            toRead -= 44;
            this.pos += 44;
        }
        switch (this.sectSize) {
            case 2336: {
                skip = 8;
                break;
            }
            case 2352: {
                skip = 24;
                break;
            }
            case 2048: {
                int ret = this.rais.read(b, off, toRead);
                if (ret != -1) {
                    this.pos += ret;
                }
                return ret;
            }
        }
        int full = toRead >> 11;
        int half = toRead % 2048;
        if (full >= 1) {
            int ret;
            for (int i = 0; i < full; ++i) {
                ret = this.rais.read(b, cur, 2048);
                if (ret != -1) {
                    this.pos += ret;
                }
                if (!this.audio) {
                    StreamUtils.skipFully(this.rais, 280 + skip);
                }
                cur += 2048;
            }
            ret = this.rais.read(b, cur, half);
            if (ret != -1) {
                this.pos += ret;
            }
        } else {
            int ret = this.rais.read(b, cur, half);
            if (ret != -1) {
                this.pos += ret;
            }
            if (this.pos % 2048 == 0 && !this.audio) {
                StreamUtils.skipFully(this.rais, 280 + skip);
            }
        }
        return this.pos - before;
    }

    public int available() throws IOException {
        int available = (int)(this.size - (long)this.pos);
        return available < 0 ? 0 : available;
    }

    public void close() throws IOException {
        this.rais.close();
    }
}

