/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.iso;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.iso.IsoArchiveEntry;
import com.mucommander.commons.file.impl.iso.IsoUtil;
import com.mucommander.commons.file.impl.iso.NrgParser;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IsoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsoParser.class);
    private static int S_IFREG = 32768;
    private static int S_IFDIR = 16384;

    IsoParser() {
    }

    public static Vector<IsoArchiveEntry> getEntries(byte[] buffer, RandomAccessInputStream rais, int sectSize, long sector_offset, long shiftOffset) throws Exception {
        Vector<IsoArchiveEntry> entries = new Vector<IsoArchiveEntry>();
        Calendar calendar = Calendar.getInstance();
        int start = 16;
        isoPvd pvd = null;
        todo todo_idr = null;
        int level = 0;
        for (int i = 1; i < 17; ++i) {
            pvd = new isoPvd(buffer, rais, start + i, sectSize, shiftOffset);
            if (pvd.type[0] != 2 || pvd.id[0] != 67 || pvd.id[1] != 68 || pvd.id[2] != 48 || pvd.id[3] != 48 || pvd.id[4] != 49) continue;
            switch (pvd.unused3[2]) {
                case 64: {
                    level = 1;
                    break;
                }
                case 67: {
                    level = 2;
                    break;
                }
                case 69: {
                    level = 3;
                }
            }
            break;
        }
        if (level == 0) {
            pvd = new isoPvd(buffer, rais, start, sectSize, shiftOffset);
        }
        isoDr idr = new isoDr(pvd.root_directory_record, 0);
        todo_idr = IsoParser.parse_dir(todo_idr, "", IsoParser.isonum_733(idr.extent), IsoParser.isonum_733(idr.size), rais, buffer, entries, sectSize, level, shiftOffset, sector_offset, calendar);
        while (todo_idr != null) {
            todo_idr = IsoParser.parse_dir(todo_idr, todo_idr.name, todo_idr.extent, todo_idr.length, rais, buffer, entries, sectSize, level, shiftOffset, sector_offset, calendar);
            todo_idr = todo_idr.next;
        }
        return entries;
    }

    static Vector<IsoArchiveEntry> getEntries(AbstractFile file, RandomAccessInputStream rais) throws IOException {
        byte[] buffer = BufferPool.getByteArray(2048);
        try {
            if ("nrg".equals(file.getExtension())) {
                Vector<IsoArchiveEntry> vector = NrgParser.getEntries(buffer, file, rais);
                return vector;
            }
            int sectSize = IsoUtil.guessSectorSize(file);
            long sector_offset = 0L;
            long shiftOffset = 0L;
            Vector<IsoArchiveEntry> vector = IsoParser.getEntries(buffer, rais, sectSize, sector_offset, shiftOffset);
            return vector;
        }
        catch (Exception e) {
            LOGGER.info("Exception caught while parsing iso, throwing IOException", e);
            throw new IOException();
        }
        finally {
            BufferPool.releaseByteArray(buffer);
        }
    }

    private static void newString(byte[] b, int len, int level, StringBuffer name) throws Exception {
        name.append(level == 0 ? new String(b, 0, len) : new String(b, 0, len, "UnicodeBigUnmarked"));
    }

    public static todo parse_dir(todo todo_idr, String rootname, int extent, int len, RandomAccessInputStream rais, byte[] buffer, Vector<IsoArchiveEntry> entries, int sectSize, int level, long shiftOffset, long sector_offset, Calendar calendar) throws Exception {
        block0: while (len > 0) {
            isoDr idr;
            rais.seek(IsoUtil.offsetInSector((long)extent - sector_offset, sectSize, false) + shiftOffset);
            StreamUtils.readFully(rais, buffer);
            len -= buffer.length;
            ++extent;
            int i = 0;
            do {
                idr = new isoDr(buffer, i);
                if (idr.length[0] == 0) continue block0;
                stat fstat_buf = new stat();
                StringBuffer name_buf = new StringBuffer();
                fstat_buf.st_size = IsoParser.isonum_733(idr.size);
                fstat_buf.st_mode = (idr.flags[0] & 2) > 0 ? (fstat_buf.st_mode |= S_IFDIR) : (fstat_buf.st_mode |= S_IFREG);
                if (idr.name_len[0] == 1 && idr.name[0] == 0) {
                    name_buf.append(".");
                } else if (idr.name_len[0] == 1 && idr.name[0] == 1) {
                    name_buf.append("..");
                } else {
                    int s;
                    IsoParser.newString(idr.name, idr.name_len[0] & 0xFF, level, name_buf);
                    int p = name_buf.lastIndexOf(";");
                    if (p != -1) {
                        name_buf.setLength(p);
                    }
                    if ((p = name_buf.lastIndexOf(".")) != -1 && p == (s = name_buf.length() - 1)) {
                        name_buf.setLength(s);
                    }
                }
                if ((idr.flags[0] & 2) != 0 && (idr.name_len[0] != 1 || idr.name[0] != 0 && idr.name[0] != 1)) {
                    todo td = todo_idr;
                    if (td != null) {
                        while (td.next != null) {
                            td = td.next;
                        }
                        td = td.next = new todo();
                    } else {
                        todo_idr = td = new todo();
                    }
                    td.next = null;
                    td.extent = IsoParser.isonum_733(idr.extent);
                    td.length = IsoParser.isonum_733(idr.size);
                    td.name = rootname + name_buf + "/";
                }
                boolean dir = false;
                String n = name_buf.toString();
                if (".".equals(n) || "..".equals(n)) continue;
                StringBuffer name = new StringBuffer(rootname);
                name.append(n);
                if (IsoParser.S_ISDIR(fstat_buf.st_mode)) {
                    dir = true;
                    if (!n.endsWith("/")) {
                        name.append('/');
                    }
                }
                calendar.set((idr.date[0] & 0xFF) + 1900, idr.date[1] - 1, idr.date[2], idr.date[3], idr.date[4], idr.date[5]);
                calendar.setTimeZone(new SimpleTimeZone(900000 * idr.date[6], ""));
                entries.add(new IsoArchiveEntry(name.toString(), dir, calendar.getTimeInMillis(), fstat_buf.st_size, (long)IsoParser.isonum_733(idr.extent) - sector_offset, sectSize, shiftOffset, false));
            } while ((i += buffer[i] & 0xFF) <= 2048 - idr.s_length);
        }
        return todo_idr;
    }

    private static int ISODCL(int start, int end) {
        return end - start + 1;
    }

    private static int isonum_731(byte[] p) {
        return IsoUtil.toDwordBE(p, 0);
    }

    public static int isonum_733(byte[] p) {
        return IsoParser.isonum_731(p);
    }

    private static boolean S_ISDIR(int m) {
        return (m & S_IFDIR) == S_IFDIR;
    }

    static /* synthetic */ int access$100(int x0, int x1) {
        return IsoParser.ISODCL(x0, x1);
    }

    public static class isoPvd {
        public byte[] type = new byte[IsoParser.access$100(1, 1)];
        public byte[] id = new byte[IsoParser.access$100(2, 6)];
        public byte[] version = new byte[IsoParser.access$100(7, 7)];
        public byte[] unused1 = new byte[IsoParser.access$100(8, 8)];
        public byte[] system_id = new byte[IsoParser.access$100(9, 40)];
        public byte[] volume_id = new byte[IsoParser.access$100(41, 72)];
        public byte[] unused2 = new byte[IsoParser.access$100(73, 80)];
        public byte[] volume_space_size = new byte[IsoParser.access$100(81, 88)];
        public byte[] unused3 = new byte[IsoParser.access$100(89, 120)];
        public byte[] volume_set_size = new byte[IsoParser.access$100(121, 124)];
        public byte[] volume_sequence_number = new byte[IsoParser.access$100(125, 128)];
        public byte[] logical_block_size = new byte[IsoParser.access$100(129, 132)];
        public byte[] path_table_size = new byte[IsoParser.access$100(133, 140)];
        public byte[] type_l_path_table = new byte[IsoParser.access$100(141, 144)];
        public byte[] opt_type_l_path_table = new byte[IsoParser.access$100(145, 148)];
        public byte[] type_m_path_table = new byte[IsoParser.access$100(149, 152)];
        public byte[] opt_type_m_path_table = new byte[IsoParser.access$100(153, 156)];
        public byte[] root_directory_record = new byte[IsoParser.access$100(157, 190)];
        public byte[] volume_set_id = new byte[IsoParser.access$100(191, 318)];
        public byte[] publisher_id = new byte[IsoParser.access$100(319, 446)];
        public byte[] preparer_id = new byte[IsoParser.access$100(447, 574)];
        public byte[] application_id = new byte[IsoParser.access$100(575, 702)];
        public byte[] copyright_file_id = new byte[IsoParser.access$100(703, 739)];
        public byte[] abstract_file_id = new byte[IsoParser.access$100(740, 776)];
        public byte[] bibliographic_file_id = new byte[IsoParser.access$100(777, 813)];
        public byte[] creation_date = new byte[IsoParser.access$100(814, 830)];
        public byte[] modification_date = new byte[IsoParser.access$100(831, 847)];
        public byte[] expiration_date = new byte[IsoParser.access$100(848, 864)];
        public byte[] effective_date = new byte[IsoParser.access$100(865, 881)];
        public byte[] file_structure_version = new byte[IsoParser.access$100(882, 882)];
        public byte[] unused4 = new byte[IsoParser.access$100(883, 883)];
        public byte[] application_data = new byte[IsoParser.access$100(884, 1395)];
        public byte[] unused5 = new byte[IsoParser.access$100(1396, 2048)];
        byte[][] dataPvr = new byte[][]{this.type, this.id, this.version, this.unused1, this.system_id, this.volume_id, this.unused2, this.volume_space_size, this.unused3, this.volume_set_size, this.volume_sequence_number, this.logical_block_size, this.path_table_size, this.type_l_path_table, this.opt_type_l_path_table, this.type_m_path_table, this.opt_type_m_path_table, this.root_directory_record, this.volume_set_id, this.publisher_id, this.preparer_id, this.application_id, this.copyright_file_id, this.abstract_file_id, this.bibliographic_file_id, this.creation_date, this.modification_date, this.expiration_date, this.effective_date, this.file_structure_version, this.unused4, this.application_data, this.unused5};

        public isoPvd(byte[] pvd, RandomAccessInputStream rais, int start, int sectSize, long shiftOffset) throws IOException {
            rais.seek(IsoUtil.offsetInSector(start, sectSize, false) + shiftOffset);
            if (rais.read(pvd) == -1) {
                throw new IOException("unable to read PVD");
            }
            this.load(pvd);
        }

        void load(byte[] src) {
            int pos = 0;
            int max = this.dataPvr.length;
            for (int i = 0; i < max; ++i) {
                System.arraycopy(src, pos, this.dataPvr[i], 0, this.dataPvr[i].length);
                pos += this.dataPvr[i].length;
            }
        }
    }

    public static class isoDr {
        public byte[] length = new byte[IsoParser.access$100(1, 1)];
        public byte[] ext_attr_length = new byte[IsoParser.access$100(2, 2)];
        public byte[] extent = new byte[IsoParser.access$100(3, 10)];
        public byte[] size = new byte[IsoParser.access$100(11, 18)];
        public byte[] date = new byte[IsoParser.access$100(19, 25)];
        public byte[] flags = new byte[IsoParser.access$100(26, 26)];
        public byte[] file_unit_size = new byte[IsoParser.access$100(27, 27)];
        public byte[] interleave = new byte[IsoParser.access$100(28, 28)];
        public byte[] volume_sequence_number = new byte[IsoParser.access$100(29, 32)];
        public byte[] name_len = new byte[IsoParser.access$100(33, 33)];
        public byte[] name = new byte[128];
        public int s_length = 34;
        public byte[][] dataDr = new byte[][]{this.length, this.ext_attr_length, this.extent, this.size, this.date, this.flags, this.file_unit_size, this.interleave, this.volume_sequence_number, this.name_len, this.name};

        public isoDr(byte[] src, int pos) {
            int max = this.dataDr.length;
            for (int i = 0; i < max; ++i) {
                int l = this.dataDr[i].length;
                if (src.length - pos < this.dataDr[i].length && i == 10) {
                    l = src.length - pos;
                }
                System.arraycopy(src, pos, this.dataDr[i], 0, l);
                pos += this.dataDr[i].length;
            }
        }
    }

    public static class todo {
        public todo next;
        public String name;
        public int extent;
        public int length;
    }

    private static class stat {
        int st_size;
        int st_mode;

        private stat() {
        }
    }
}

