/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.iso;

import com.mucommander.commons.file.AbstractFile;

class IsoUtil {
    IsoUtil() {
    }

    public static int guessSectorSize(AbstractFile file) {
        int sectSize = 2048;
        if (file.getSize() % 2352L == 0L) {
            sectSize = 2352;
        } else if (file.getSize() % 2336L == 0L) {
            sectSize = 2336;
        }
        return sectSize;
    }

    public static int toDwordBE(byte[] p, int offset) {
        return p[offset] & 0xFF | (p[1 + offset] & 0xFF) << 8 | (p[2 + offset] & 0xFF) << 16 | (p[3 + offset] & 0xFF) << 24;
    }

    public static int toDword(byte[] p, int offset) {
        return p[3 + offset] & 0xFF | (p[2 + offset] & 0xFF) << 8 | (p[1 + offset] & 0xFF) << 16 | (p[offset] & 0xFF) << 24;
    }

    public static void toArray(int value, byte[] b, int offset) {
        b[offset] = (byte)(value & 0xFF);
        b[offset + 1] = (byte)((value & 0xFF00) >> 8);
        b[offset + 2] = (byte)((value & 0xFF0000) >> 16);
        b[offset + 3] = (byte)((value & 0xFF000000) >> 24);
    }

    public static long offsetInSector(long index, int sectSize, boolean audio) {
        switch (sectSize) {
            case 2352: {
                return index * 2352L + (long)(audio ? 0 : 24);
            }
            case 2336: {
                return index * 2336L + 8L;
            }
        }
        return index << 11;
    }
}

