/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.iso;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.impl.iso.IsoArchiveEntry;
import com.mucommander.commons.file.impl.iso.IsoParser;
import com.mucommander.commons.file.impl.iso.IsoUtil;
import com.mucommander.commons.io.RandomAccessInputStream;
import java.io.IOException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NrgParser
extends IsoParser {
    NrgParser() {
    }

    static Vector<IsoArchiveEntry> getEntries(byte[] buffer, AbstractFile file, RandomAccessInputStream rais) throws Exception {
        int sectSize = 2048;
        long sector_offset = 0L;
        long shiftOffset = 0L;
        int len = rais.available();
        int[] tracksMode = new int[255];
        long[] tracksOffset = new long[255];
        long[] tracksStart = new long[255];
        long[] tracksEnd = new long[255];
        int tracks = 0;
        for (int i = 7; i <= 11; i += 4) {
            long offset = -1L;
            rais.seek(len - i);
            if (rais.read(buffer, 0, i == 7 ? 4 : 12) == -1) {
                throw new IOException("unable to read tail of nrg file");
            }
            if (buffer[0] == 78 && buffer[1] == 69 && buffer[2] == 82 && buffer[3] == 53) {
                offset = IsoUtil.toDword(buffer, 8);
            } else if (buffer[0] == 78 && buffer[1] == 69 && buffer[2] == 82 && buffer[3] == 79) {
                offset = IsoUtil.toDword(buffer, 4);
            }
            if (offset == -1L) continue;
            boolean end = false;
            for (int j = 0; j < 255 && !end; ++j) {
                long clen;
                rais.seek(offset);
                if (rais.read(buffer, 0, 8) == -1) {
                    throw new IOException("unable to read chunk in tail of nrg file");
                }
                if (buffer[0] == 69 && buffer[1] == 78 && buffer[2] == 68 && buffer[3] == 33) {
                    end = true;
                    continue;
                }
                if (buffer[0] == 69 && buffer[1] == 84 && buffer[2] == 78) {
                    boolean ETN2;
                    clen = IsoUtil.toDword(buffer, 4);
                    boolean bl = ETN2 = buffer[3] == 50;
                    if (rais.read(buffer, 0, (int)clen) == -1) {
                        throw new IOException("unable to read chunk in tail of nrg file");
                    }
                    int z = 0;
                    while ((long)z < clen) {
                        tracksOffset[tracks] = IsoUtil.toDword(buffer, ETN2 ? 4 : 0);
                        tracksMode[tracks] = IsoUtil.toDword(buffer, ETN2 ? 16 : 8);
                        ++tracks;
                        z += ETN2 ? 32 : 20;
                    }
                    end = true;
                    continue;
                }
                if (buffer[0] == 68 && buffer[1] == 65 && buffer[2] == 79) {
                    boolean DAOX = buffer[3] == 88;
                    clen = IsoUtil.toDword(buffer, 4);
                    offset += 8L + clen;
                    if (rais.read(buffer, 0, 4) == -1) {
                        throw new IOException("unable to skip endian in DAO chunk");
                    }
                    if (rais.read(buffer, 0, (int)clen) == -1) {
                        throw new IOException("unable to read DAO chunk");
                    }
                    byte first = buffer[16];
                    int cur = first - 1;
                    int z = 18;
                    while ((long)z < clen - 4L) {
                        tracksMode[cur] = buffer[z + 14];
                        tracksOffset[cur] = IsoUtil.toDword(buffer, DAOX ? z + 30 : 22);
                        tracksEnd[cur] = IsoUtil.toDword(buffer, DAOX ? z + 38 : 26) - 1;
                        ++cur;
                        z += DAOX ? 42 : 30;
                    }
                    tracks = cur;
                    rais.seek(offset);
                    continue;
                }
                if (buffer[0] == 67 && buffer[1] == 85 && buffer[2] == 69 && buffer[3] == 88) {
                    clen = IsoUtil.toDword(buffer, 4);
                    offset += 8L + clen;
                    if (rais.read(buffer, 0, (int)clen) == -1) {
                        throw new IOException("unable to read CUEX chunk");
                    }
                    int z = 0;
                    while ((long)z < clen) {
                        long tstart = IsoUtil.toDword(buffer, z + 4);
                        if (buffer[z + 2] != 0 && (buffer[z + 1] & 0xFF) != 170) {
                            tracksStart[tracks] = tstart;
                            ++tracks;
                        }
                        z += 8;
                    }
                    rais.seek(offset);
                    continue;
                }
                clen = IsoUtil.toDword(buffer, 4);
                rais.seek(offset += 8L + clen);
            }
            boolean audioOnly = true;
            block11: for (int k = 0; k < tracks; ++k) {
                shiftOffset = tracksOffset[k];
                sector_offset = tracksStart[k];
                switch (tracksMode[k]) {
                    case 0: {
                        sectSize = 2048;
                        audioOnly = false;
                        continue block11;
                    }
                    case 3: {
                        sectSize = 2336;
                        audioOnly = false;
                        continue block11;
                    }
                    case 7: {
                        sectSize = 2352;
                        continue block11;
                    }
                    case 16: {
                        continue block11;
                    }
                    default: {
                        throw new Exception("unhandled mode " + tracksMode[k]);
                    }
                }
            }
            if (!audioOnly) continue;
            Vector<IsoArchiveEntry> entries = new Vector<IsoArchiveEntry>();
            for (int k = 0; k < tracks; ++k) {
                entries.add(new IsoArchiveEntry(file.getName() + ".TRACK" + (k + 1) + ".wav", false, file.getDate(), tracksEnd[k] - tracksOffset[k] + 44L, 0L, sectSize, tracksOffset[k], true));
            }
            return entries;
        }
        return NrgParser.getEntries(buffer, rais, sectSize, sector_offset, shiftOffset);
    }
}

