/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.rar;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.WrapperArchiveEntryIterator;
import com.mucommander.commons.file.impl.rar.RarFile;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class RarArchiveFile
extends AbstractROArchiveFile {
    private RarFile rarFile;
    private long lastRarFileDate;

    public RarArchiveFile(AbstractFile file) throws IOException {
        super(file);
    }

    private void checkRarFile() throws IOException, UnsupportedFileOperationException, RarException {
        long currentDate = this.file.getDate();
        if (this.rarFile == null || currentDate != this.lastRarFileDate) {
            this.rarFile = new RarFile(this.file);
            this.declareRarFileUpToDate(currentDate);
        }
    }

    private void declareRarFileUpToDate(long currentFileDate) {
        this.lastRarFileDate = currentFileDate;
    }

    private ArchiveEntry createArchiveEntry(FileHeader header) {
        return new ArchiveEntry(header.getFileNameString().replace('\\', '/'), header.isDirectory(), header.getMTime().getTime(), header.getFullUnpackSize(), true);
    }

    public synchronized ArchiveEntryIterator getEntryIterator() throws IOException, UnsupportedFileOperationException {
        try {
            this.checkRarFile();
        }
        catch (RarException e) {
            throw new IOException();
        }
        Vector<ArchiveEntry> entries = new Vector<ArchiveEntry>();
        for (FileHeader o : this.rarFile.getEntries()) {
            entries.add(this.createArchiveEntry(o));
        }
        return new WrapperArchiveEntryIterator(entries.iterator());
    }

    public synchronized InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        try {
            this.checkRarFile();
        }
        catch (RarException e) {
            throw new IOException();
        }
        try {
            return this.rarFile.getEntryInputStream(entry.getPath().replace('/', '\\'));
        }
        catch (RarException e) {
            throw new IOException();
        }
    }
}

