/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.s3;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.SyncedFileAttributes;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.s3.S3File;
import com.mucommander.commons.io.RandomAccessInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Bucket
extends S3File {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3File.class);
    private String bucketName;
    private S3BucketFileAttributes atts;
    private static final FilePermissions DEFAULT_PERMISSIONS = new SimpleFilePermissions(448);

    protected S3Bucket(FileURL url, S3Service service, String bucketName) throws AuthException {
        super(url, service);
        this.bucketName = bucketName;
        this.atts = new S3BucketFileAttributes();
    }

    protected S3Bucket(FileURL url, S3Service service, org.jets3t.service.model.S3Bucket bucket) throws AuthException {
        super(url, service);
        this.bucketName = bucket.getName();
        this.atts = new S3BucketFileAttributes(bucket);
    }

    public FileAttributes getFileAttributes() {
        return this.atts;
    }

    public String getOwner() {
        return this.atts.getOwner();
    }

    public boolean canGetOwner() {
        return true;
    }

    public AbstractFile[] ls() throws IOException {
        return this.listObjects(this.bucketName, "", this);
    }

    public void delete() throws IOException {
        try {
            this.service.deleteBucket(this.bucketName);
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    public void mkdir() throws IOException {
        try {
            this.service.createBucket(this.bucketName);
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public void renameTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RENAME);
    }

    @UnsupportedFileOperation
    public InputStream getInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.READ_FILE);
    }

    @UnsupportedFileOperation
    public OutputStream getOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.WRITE_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessInputStream getRandomAccessInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_READ_FILE);
    }

    private class S3BucketFileAttributes
    extends SyncedFileAttributes {
        private S3BucketFileAttributes() throws AuthException {
            super(60000L, false);
            this.fetchAttributes();
            this.updateExpirationDate();
        }

        private S3BucketFileAttributes(org.jets3t.service.model.S3Bucket bucket) throws AuthException {
            super(60000L, false);
            this.setAttributes(bucket);
            this.setExists(true);
            this.updateExpirationDate();
        }

        private void setAttributes(org.jets3t.service.model.S3Bucket bucket) {
            this.setDirectory(true);
            this.setDate(bucket.getCreationDate().getTime());
            this.setPermissions(DEFAULT_PERMISSIONS);
            this.setOwner(bucket.getOwner().getDisplayName());
        }

        private void fetchAttributes() throws AuthException {
            org.jets3t.service.model.S3Bucket bucket;
            S3ServiceException e = null;
            try {
                bucket = S3Bucket.this.service.getBucket(S3Bucket.this.bucketName);
            }
            catch (S3ServiceException ex) {
                e = ex;
                bucket = null;
            }
            if (bucket != null) {
                this.setExists(true);
                this.setAttributes(bucket);
            } else {
                this.setExists(false);
                this.setDirectory(false);
                this.setDate(0L);
                this.setPermissions(FilePermissions.EMPTY_FILE_PERMISSIONS);
                this.setOwner(null);
                if (e != null) {
                    S3File.handleAuthException(e, S3Bucket.this.fileURL);
                }
            }
        }

        public void updateAttributes() {
            try {
                this.fetchAttributes();
            }
            catch (Exception e) {
                LOGGER.info("Failed to update attributes", e);
            }
        }
    }
}

