/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.s3;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.runtime.JavaVersions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Object;

public abstract class S3File
extends ProtocolFile {
    protected S3Service service;
    protected AbstractFile parent;
    protected boolean parentSet;

    protected S3File(FileURL url, S3Service service) {
        super(url);
        this.service = service;
    }

    protected IOException getIOException(S3ServiceException e) throws IOException {
        return S3File.getIOException(e, this.fileURL);
    }

    protected static IOException getIOException(S3ServiceException e, FileURL fileURL) throws IOException {
        S3File.handleAuthException(e, fileURL);
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            return (IOException)cause;
        }
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            return new IOException(e);
        }
        return new IOException(e.getMessage());
    }

    protected static void handleAuthException(S3ServiceException e, FileURL fileURL) throws AuthException {
        int code = e.getResponseCode();
        if (code == 401 || code == 403) {
            throw new AuthException(fileURL);
        }
    }

    protected AbstractFile[] listObjects(String bucketName, String prefix, S3File parent) throws IOException {
        try {
            FileURL childURL;
            S3ObjectsChunk chunk = this.service.listObjectsChunked(bucketName, prefix, "/", 1000L, null, true);
            S3Object[] objects = chunk.getObjects();
            String[] commonPrefixes = chunk.getCommonPrefixes();
            if (objects.length == 0 && !prefix.equals("")) {
                throw new IOException();
            }
            AbstractFile[] children = new AbstractFile[objects.length + commonPrefixes.length];
            int i = 0;
            for (S3Object object : objects) {
                String objectKey = object.getKey();
                if (objectKey.equals(prefix)) continue;
                childURL = (FileURL)this.fileURL.clone();
                childURL.setPath(bucketName + "/" + objectKey);
                children[i] = FileFactory.getFile(childURL, (AbstractFile)parent, this.service, object);
                ++i;
            }
            for (String commonPrefix : commonPrefixes) {
                childURL = (FileURL)this.fileURL.clone();
                childURL.setPath(bucketName + "/" + commonPrefix);
                S3Object directoryObject = new S3Object(commonPrefix);
                directoryObject.setLastModifiedDate(new Date(System.currentTimeMillis()));
                directoryObject.setContentLength(0L);
                children[i] = FileFactory.getFile(childURL, (AbstractFile)parent, this.service, directoryObject);
                ++i;
            }
            if (i < children.length) {
                AbstractFile[] childrenTrimmed = new AbstractFile[i];
                System.arraycopy(children, 0, childrenTrimmed, 0, i);
                return childrenTrimmed;
            }
            return children;
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    public abstract FileAttributes getFileAttributes();

    public AbstractFile getParent() {
        if (!this.parentSet) {
            FileURL parentFileURL = this.fileURL.getParent();
            if (parentFileURL != null) {
                try {
                    this.parent = FileFactory.getFile(parentFileURL, null, this.service);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.parentSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentSet = true;
    }

    public long getDate() {
        return this.getFileAttributes().getDate();
    }

    public long getSize() {
        return this.getFileAttributes().getSize();
    }

    public boolean exists() {
        return this.getFileAttributes().exists();
    }

    public boolean isDirectory() {
        return this.getFileAttributes().isDirectory();
    }

    public FilePermissions getPermissions() {
        return this.getFileAttributes().getPermissions();
    }

    public Object getUnderlyingFileObject() {
        return this.getFileAttributes();
    }

    public boolean isSymlink() {
        return false;
    }

    public PermissionBits getChangeablePermissions() {
        return PermissionBits.EMPTY_PERMISSION_BITS;
    }

    @UnsupportedFileOperation
    public void changePermission(int access, int permission, boolean enabled) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_PERMISSION);
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }

    @UnsupportedFileOperation
    public OutputStream getAppendOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.APPEND_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    @UnsupportedFileOperation
    public long getFreeSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_FREE_SPACE);
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    @UnsupportedFileOperation
    public void changeDate(long lastModified) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.CHANGE_DATE);
    }
}

