/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.s3;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.SyncedFileAttributes;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.s3.S3File;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.model.S3Owner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Object
extends S3File {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Object.class);
    private String bucketName;
    private S3ObjectFileAttributes atts;
    private static final FilePermissions DEFAULT_PERMISSIONS = new SimpleFilePermissions(384);

    protected S3Object(FileURL url, S3Service service, String bucketName) throws AuthException {
        super(url, service);
        this.bucketName = bucketName;
        this.atts = new S3ObjectFileAttributes();
    }

    protected S3Object(FileURL url, S3Service service, String bucketName, org.jets3t.service.model.S3Object object) throws AuthException {
        super(url, service);
        this.bucketName = bucketName;
        this.atts = new S3ObjectFileAttributes(object);
    }

    private String getObjectKey() {
        String urlPath = this.fileURL.getPath();
        return urlPath.substring(this.bucketName.length() + 2, urlPath.length());
    }

    private String getObjectKey(boolean wantTrailingSeparator) {
        String objectKey = this.getObjectKey();
        return wantTrailingSeparator ? this.addTrailingSeparator(objectKey) : this.removeTrailingSeparator(objectKey);
    }

    private void putObject(InputStream in, long objectLength) throws FileTransferException {
        try {
            org.jets3t.service.model.S3Object object = new org.jets3t.service.model.S3Object(this.getObjectKey(false));
            object.setDataInputStream(in);
            object.setContentLength(objectLength);
            this.atts.setAttributes(this.service.putObject(this.bucketName, object));
            this.atts.setExists(true);
            this.atts.updateExpirationDate();
        }
        catch (S3ServiceException e) {
            throw new FileTransferException(0);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public FileAttributes getFileAttributes() {
        return this.atts;
    }

    public String getOwner() {
        return this.atts.getOwner();
    }

    public boolean canGetOwner() {
        return true;
    }

    public AbstractFile[] ls() throws IOException {
        return this.listObjects(this.bucketName, this.getObjectKey(true), this);
    }

    public void mkdir() throws IOException {
        if (this.exists()) {
            throw new IOException();
        }
        try {
            this.atts.setAttributes(this.service.putObject(this.bucketName, new org.jets3t.service.model.S3Object(this.getObjectKey(true))));
            this.atts.setExists(true);
            this.atts.updateExpirationDate();
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    public void delete() throws IOException {
        if (!this.exists()) {
            throw new IOException();
        }
        try {
            boolean isDirectory = this.isDirectory();
            if (isDirectory && this.service.listObjectsChunked(this.bucketName, this.getObjectKey(true), "/", 2L, null, false).getObjects().length > 1) {
                throw new IOException("Directory not empty");
            }
            this.service.deleteObject(this.bucketName, this.getObjectKey(isDirectory));
            this.atts.setExists(false);
            this.atts.setDirectory(false);
            this.atts.setSize(0L);
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    public void renameTo(AbstractFile destFile) throws IOException {
        this.copyTo(destFile);
        this.delete();
    }

    public void copyRemotelyTo(AbstractFile abstractFile) throws IOException {
        this.checkCopyRemotelyPrerequisites(abstractFile, true, false);
        S3Object s3Object = abstractFile.getAncestor(S3Object.class);
        try {
            boolean bl = this.isDirectory();
            org.jets3t.service.model.S3Object s3Object2 = new org.jets3t.service.model.S3Object(s3Object.getObjectKey(bl));
            s3Object2.addAllMetadata(this.service.copyObject(this.bucketName, this.getObjectKey(bl), s3Object.bucketName, s3Object2, false));
            s3Object.atts.setAttributes(s3Object2);
            s3Object.atts.setExists(true);
        }
        catch (S3ServiceException s3ServiceException) {
            throw this.getIOException(s3ServiceException);
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getInputStream(0L);
    }

    public InputStream getInputStream(long offset) throws IOException {
        try {
            return this.service.getObject(this.bucketName, this.getObjectKey(false), null, null, null, null, offset == 0L ? null : Long.valueOf(offset), null).getDataInputStream();
        }
        catch (S3ServiceException e) {
            throw this.getIOException(e);
        }
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException();
        }
        return new S3ObjectRandomAccessInputStream();
    }

    @UnsupportedFileOperation
    public OutputStream getOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.WRITE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream in, boolean append, long length) throws FileTransferException {
        if (append) {
            throw new FileTransferException(4);
        }
        if (length >= 0L) {
            this.putObject(in, length);
        } else {
            OutputStream tempOut;
            AbstractFile tempFile;
            try {
                tempFile = FileFactory.getTemporaryFile(false);
                tempOut = tempFile.getOutputStream();
            }
            catch (IOException e) {
                throw new FileTransferException(3);
            }
            try {
                InputStream tempIn;
                try {
                    StreamUtils.copyStream(in, tempOut, 65536);
                }
                finally {
                    try {
                        tempOut.close();
                    }
                    catch (IOException e) {}
                }
                try {
                    tempIn = tempFile.getInputStream();
                }
                catch (IOException e) {
                    throw new FileTransferException(2);
                }
                this.putObject(tempIn, tempFile.getSize());
            }
            finally {
                try {
                    tempFile.delete();
                }
                catch (IOException e) {}
            }
        }
    }

    private class S3ObjectFileAttributes
    extends SyncedFileAttributes {
        private S3ObjectFileAttributes() throws AuthException {
            super(60000L, false);
            this.fetchAttributes();
            this.updateExpirationDate();
        }

        private S3ObjectFileAttributes(org.jets3t.service.model.S3Object object) throws AuthException {
            super(60000L, false);
            this.setAttributes(object);
            this.setExists(true);
            this.updateExpirationDate();
        }

        private void setAttributes(org.jets3t.service.model.S3Object object) {
            this.setDirectory(object.getKey().endsWith("/"));
            this.setSize(object.getContentLength());
            this.setDate(object.getLastModifiedDate().getTime());
            this.setPermissions(DEFAULT_PERMISSIONS);
            S3Owner owner = object.getOwner();
            this.setOwner(owner == null ? null : owner.getDisplayName());
        }

        private void fetchAttributes() throws AuthException {
            try {
                this.setAttributes(S3Object.this.service.getObjectDetails(S3Object.this.bucketName, S3Object.this.getObjectKey(), null, null, null, null));
                this.setExists(true);
            }
            catch (S3ServiceException e) {
                this.setExists(false);
                this.setDirectory(false);
                this.setSize(0L);
                this.setDate(0L);
                this.setPermissions(FilePermissions.EMPTY_FILE_PERMISSIONS);
                this.setOwner(null);
                S3File.handleAuthException(e, S3Object.this.fileURL);
            }
        }

        public void updateAttributes() {
            try {
                this.fetchAttributes();
            }
            catch (Exception e) {
                LOGGER.info("Failed to update attributes", e);
            }
        }
    }

    private class S3ObjectRandomAccessInputStream
    extends RandomAccessInputStream {
        private long length;
        private long offset;
        private InputStream in;

        protected S3ObjectRandomAccessInputStream() {
            this.length = S3Object.this.getSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void openStream(long offset) throws IOException {
            if (this.in != null && this.offset == offset) {
                return;
            }
            if (this.in != null && offset > this.offset && offset - this.offset < 6666L) {
                byte[] skipBuf = BufferPool.getByteArray(6666);
                try {
                    StreamUtils.readFully(this.in, skipBuf, 0, (int)(offset - this.offset));
                    this.offset = offset;
                }
                finally {
                    BufferPool.releaseByteArray(skipBuf);
                }
            }
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (IOException e) {
                    LOGGER.info("Failed to close connection", e);
                }
            }
            try {
                this.in = S3Object.this.service.getObject(S3Object.this.bucketName, S3Object.this.getObjectKey(false), null, null, null, null, offset, null).getDataInputStream();
                this.offset = offset;
            }
            catch (S3ServiceException e) {
                throw S3Object.this.getIOException(e);
            }
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int nbRead;
            if (this.in == null) {
                this.openStream(0L);
            }
            if ((nbRead = this.in.read(b, off, len)) > 0) {
                this.offset += (long)nbRead;
            }
            return nbRead;
        }

        public synchronized int read() throws IOException {
            int i;
            if (this.in == null) {
                this.openStream(0L);
            }
            if ((i = this.in.read()) != -1) {
                ++this.offset;
            }
            return i;
        }

        public long getLength() throws IOException {
            return this.length;
        }

        public synchronized long getOffset() throws IOException {
            return this.offset;
        }

        public synchronized void seek(long offset) throws IOException {
            this.openStream(offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws IOException {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                finally {
                    this.in = null;
                    this.offset = 0L;
                }
            }
        }
    }
}

