/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.WrapperArchiveEntryIterator;
import com.mucommander.commons.file.impl.sevenzip.MuArchiveExtractCallback;
import com.mucommander.commons.file.impl.sevenzip.MuRandomAccessFile;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.Archive.IInArchive;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.Archive.SevenZip.Handler;
import com.mucommander.commons.file.impl.sevenzip.provider.SevenZip.Archive.SevenZipEntry;
import com.mucommander.commons.util.CircularByteBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenZipArchiveFile
extends AbstractROArchiveFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SevenZipArchiveFile.class);
    private IInArchive sevenZipFile;

    public SevenZipArchiveFile(AbstractFile file) throws IOException {
        super(file);
    }

    private IInArchive openSevenZipFile() throws IOException {
        if (this.sevenZipFile == null) {
            MuRandomAccessFile in = new MuRandomAccessFile(this.file);
            this.sevenZipFile = new Handler();
            if (this.sevenZipFile.Open(in) != 0) {
                throw new IOException("Error while opening 7zip archive " + this.file.getAbsolutePath());
            }
        }
        return this.sevenZipFile;
    }

    private ArchiveEntry createArchiveEntry(SevenZipEntry entry) {
        return new ArchiveEntry(entry.getName(), entry.isDirectory(), entry.getTime(), entry.getSize(), true);
    }

    public InputStream getEntryInputStream(final ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        final IInArchive sevenZipFile = this.openSevenZipFile();
        final int[] arrays = new int[1];
        for (int i = 0; i < sevenZipFile.size(); ++i) {
            if (!entry.getPath().equals(sevenZipFile.getEntry(i).getName())) continue;
            System.out.println("entry.getPath = " + entry.getPath() + ", sevenZipFile.getEntry(i).getName() " + sevenZipFile.getEntry(i).getName());
            arrays[0] = i;
            break;
        }
        final CircularByteBuffer cbb = new CircularByteBuffer(-1);
        new Thread(new Runnable(){

            public void run() {
                MuArchiveExtractCallback extractCallbackSpec = new MuArchiveExtractCallback(cbb.getOutputStream(), entry.getPath());
                extractCallbackSpec.Init(sevenZipFile);
                try {
                    sevenZipFile.Extract(arrays, 1, 0, extractCallbackSpec);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return cbb.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveEntryIterator getEntryIterator() throws IOException {
        IInArchive sevenZipFile = this.openSevenZipFile();
        int nbEntries = sevenZipFile.size();
        Vector<ArchiveEntry> entries = new Vector<ArchiveEntry>();
        for (int i = 0; i < nbEntries; ++i) {
            entries.add(this.createArchiveEntry(sevenZipFile.getEntry(i)));
        }
        WrapperArchiveEntryIterator wrapperArchiveEntryIterator = new WrapperArchiveEntryIterator(entries.iterator());
        return wrapperArchiveEntryIterator;
    }
}

