/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sevenzip.provider.Common;

public class LongVector {
    protected long[] data = new long[10];
    int capacityIncr = 10;
    int elt = 0;

    public int size() {
        return this.elt;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            long[] oldData = this.data;
            int newCapacity = oldCapacity + this.capacityIncr;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new long[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.elt);
        }
    }

    public long get(int index) {
        if (index >= this.elt) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.data[index];
    }

    public void Reserve(int s) {
        this.ensureCapacity(s);
    }

    public void add(long b) {
        this.ensureCapacity(this.elt + 1);
        this.data[this.elt++] = b;
    }

    public void clear() {
        this.elt = 0;
    }

    public boolean isEmpty() {
        return this.elt == 0;
    }

    public long Back() {
        if (this.elt < 1) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return this.data[this.elt - 1];
    }

    public long Front() {
        if (this.elt < 1) {
            throw new ArrayIndexOutOfBoundsException(0);
        }
        return this.data[0];
    }

    public void DeleteBack() {
        this.remove(this.elt - 1);
    }

    public long remove(int index) {
        if (index >= this.elt) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        long oldValue = this.data[index];
        int numMoved = this.elt - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elt, index + 1, this.elt, index, numMoved);
        }
        return oldValue;
    }
}

