/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.sftp;

import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.connection.ConnectionHandler;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.authentication.KBIRequestHandler;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.IgnoreHostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SFTPConnectionHandler
extends ConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SFTPConnectionHandler.class);
    SshClient sshClient;
    SftpClient sftpClient;
    SftpSubsystemClient sftpSubsystem;

    SFTPConnectionHandler(FileURL location) {
        super(location);
    }

    public void startConnection() throws IOException {
        LOGGER.info("starting connection to {}", this.realm);
        try {
            FileURL realm = this.getRealm();
            final Credentials credentials = this.getCredentials();
            if (credentials == null) {
                this.throwAuthException("Login and password required");
            }
            LOGGER.trace("creating SshClient");
            this.sshClient = new SshClient();
            int port = realm.getPort();
            if (port == -1) {
                port = 22;
            }
            this.sshClient.connect(realm.getHost(), port, new IgnoreHostKeyVerification());
            List authMethods = this.sshClient.getAvailableAuthMethods(credentials.getLogin());
            if (authMethods == null) {
                throw new IOException();
            }
            LOGGER.info("getAvailableAuthMethods()={}", this.sshClient.getAvailableAuthMethods(credentials.getLogin()));
            SshAuthenticationClient authClient = null;
            String privateKeyPath = realm.getProperty("privateKeyPath");
            if (authMethods.contains("publickey") && privateKeyPath != null) {
                LOGGER.info("Using {} authentication method", "publickey");
                PublicKeyAuthenticationClient pk = new PublicKeyAuthenticationClient();
                pk.setUsername(credentials.getLogin());
                SshPrivateKey key = null;
                try {
                    SshPrivateKeyFile file = SshPrivateKeyFile.parse(new File(privateKeyPath));
                    key = file.toPrivateKey(credentials.getPassword());
                }
                catch (InvalidSshKeyException iske) {
                    this.throwAuthException("Invalid private key file or passphrase");
                }
                catch (IOException ioe) {
                    this.throwAuthException("Error reading private key file");
                }
                pk.setKey(key);
                authClient = pk;
            } else if (!authMethods.contains("password") && authMethods.contains("keyboard-interactive") && privateKeyPath == null) {
                LOGGER.info("Using {} authentication method", "keyboard-interactive");
                KBIAuthenticationClient kbi = new KBIAuthenticationClient();
                kbi.setUsername(credentials.getLogin());
                kbi.setKBIRequestHandler(new KBIRequestHandler(){

                    public void showPrompts(String name, String instruction, KBIPrompt[] prompts) {
                        if (prompts == null) {
                            LOGGER.trace("prompts is null!");
                            return;
                        }
                        for (int i = 0; i < prompts.length; ++i) {
                            LOGGER.trace("prompts[{}]={}", i, prompts[i].getPrompt());
                            prompts[i].setResponse(credentials.getPassword());
                        }
                    }
                });
                authClient = kbi;
            } else if (privateKeyPath == null) {
                LOGGER.info("Using {} authentication method", "password");
                PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
                pwd.setUsername(credentials.getLogin());
                pwd.setPassword(credentials.getPassword());
                authClient = pwd;
            }
            try {
                int authResult = this.sshClient.authenticate(authClient);
                if (authResult != 4) {
                    this.throwAuthException("Login or password rejected");
                }
                LOGGER.info("authentication complete, authResult={}", authResult);
            }
            catch (IOException e) {
                if (e instanceof AuthException) {
                    throw e;
                }
                LOGGER.info("Caught exception while authenticating", e);
                this.throwAuthException(e.getMessage());
            }
            this.sftpClient = this.sshClient.openSftpClient();
            this.sftpSubsystem = this.sshClient.openSftpChannel();
        }
        catch (IOException e) {
            LOGGER.info("IOException thrown while starting connection", e);
            if (this.sshClient != null && this.sshClient.isConnected()) {
                this.sshClient.disconnect();
            }
            this.sshClient = null;
            this.sftpClient = null;
            this.sftpSubsystem = null;
            throw e;
        }
    }

    public synchronized boolean isConnected() {
        return this.sshClient != null && this.sshClient.isConnected() && this.sftpClient != null && !this.sftpClient.isClosed() && this.sftpSubsystem != null && !this.sftpSubsystem.isClosed();
    }

    public synchronized void closeConnection() {
        if (this.sftpClient != null) {
            try {
                this.sftpClient.quit();
            }
            catch (IOException e) {
                LOGGER.info("IOException caught while calling sftpClient.quit()", e);
            }
        }
        if (this.sftpSubsystem != null) {
            try {
                this.sftpSubsystem.close();
            }
            catch (IOException e) {
                LOGGER.info("IOException caught while calling sftpChannel.close ()");
            }
        }
        if (this.sshClient != null) {
            this.sshClient.disconnect();
        }
    }

    public void keepAlive() {
    }
}

