/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.smb;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.GroupedPermissionBits;
import com.mucommander.commons.file.IndividualPermissionBits;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.ProtocolFile;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;
import jcifs.smb.SmbFilenameFilter;
import jcifs.smb.SmbRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMBFile
extends ProtocolFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMBFile.class);
    private SmbFile file;
    private FilePermissions permissions;
    private AbstractFile parent;
    private boolean parentValSet;
    private static final PermissionBits CHANGEABLE_PERMISSIONS = new GroupedPermissionBits(128);

    protected SMBFile(FileURL fileURL) throws IOException {
        this(fileURL, null);
    }

    protected SMBFile(FileURL fileURL, SmbFile smbFile) throws IOException {
        block7: {
            super(fileURL);
            if (!fileURL.containsCredentials()) {
                throw new AuthException(fileURL, "Authentication required");
            }
            if (smbFile == null) {
                while (true) {
                    this.file = SMBFile.createSmbFile(fileURL);
                    try {
                        if (this.file.isDirectory() && !this.getURL().getPath().endsWith("/")) {
                            fileURL.setPath(fileURL.getPath() + '/');
                            continue;
                        }
                        break block7;
                    }
                    catch (SmbException e) {
                        if (e instanceof SmbAuthException) {
                            throw new AuthException(fileURL, e.getMessage());
                        }
                        break block7;
                    }
                }
            }
            this.file = smbFile;
        }
        this.permissions = new SMBFilePermissions(this.file);
    }

    private static SmbFile createSmbFile(FileURL url) throws MalformedURLException {
        String domain;
        Credentials credentials = url.getCredentials();
        if (credentials == null) {
            return new SmbFile(url.toString(false));
        }
        String login = credentials.getLogin();
        int domainStart = login.indexOf(";");
        if (domainStart != -1) {
            domain = login.substring(0, domainStart);
            login = login.substring(domainStart + 1, login.length());
        } else {
            domain = null;
        }
        return new SmbFile(url.toString(false), new NtlmPasswordAuthentication(domain, login, credentials.getPassword()));
    }

    private void checkSmbFile(boolean directory) {
        try {
            String path = this.file.getURL().getPath();
            boolean endsWithSeparator = path.endsWith("/");
            if (directory) {
                if (!endsWithSeparator) {
                    this.fileURL.setPath(path + "/");
                    this.file = SMBFile.createSmbFile(this.fileURL);
                }
            } else if (endsWithSeparator) {
                this.fileURL.setPath(this.removeTrailingSeparator(path));
                this.file = SMBFile.createSmbFile(this.fileURL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public long getDate() {
        try {
            return this.file.lastModified();
        }
        catch (SmbException e) {
            return 0L;
        }
    }

    public void changeDate(long lastModified) throws IOException {
        this.file.setLastModified(lastModified);
    }

    public long getSize() {
        try {
            return this.file.length();
        }
        catch (SmbException e) {
            return 0L;
        }
    }

    public AbstractFile getParent() {
        if (!this.parentValSet) {
            FileURL parentURL = this.fileURL.getParent();
            if (parentURL != null) {
                this.parent = FileFactory.getFile(parentURL);
            }
            this.parentValSet = true;
        }
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
        this.parentValSet = true;
    }

    public boolean exists() {
        try {
            return this.file.exists();
        }
        catch (IOException e) {
            LOGGER.info("Exception caught while calling SmbFile#exists()", e);
            return e instanceof SmbAuthException;
        }
    }

    public FilePermissions getPermissions() {
        return this.permissions;
    }

    public PermissionBits getChangeablePermissions() {
        return CHANGEABLE_PERMISSIONS;
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException {
        if (access != 2 || permission != 2) {
            throw new IOException();
        }
        if (enabled) {
            this.file.setReadWrite();
        } else {
            this.file.setReadOnly();
        }
    }

    public String getOwner() {
        return null;
    }

    public boolean canGetOwner() {
        return false;
    }

    public String getGroup() {
        return null;
    }

    public boolean canGetGroup() {
        return false;
    }

    public boolean isDirectory() {
        try {
            return this.file.isDirectory();
        }
        catch (SmbException e) {
            return false;
        }
    }

    public boolean isSymlink() {
        return false;
    }

    public InputStream getInputStream() throws IOException {
        return new SmbFileInputStream(this.file);
    }

    public OutputStream getOutputStream() throws IOException {
        return new SmbFileOutputStream(this.file, false);
    }

    public OutputStream getAppendOutputStream() throws IOException {
        return new SmbFileOutputStream(this.file, true);
    }

    public RandomAccessInputStream getRandomAccessInputStream() throws IOException {
        if (!this.exists()) {
            throw new IOException();
        }
        return new SMBRandomAccessInputStream(new SmbRandomAccessFile(this.file, "r"));
    }

    public RandomAccessOutputStream getRandomAccessOutputStream() throws IOException {
        return new SMBRandomAccessOutputStream(new SmbRandomAccessFile(this.file, "rw"));
    }

    public void delete() throws IOException {
        this.file.delete();
        this.checkSmbFile(false);
    }

    public AbstractFile[] ls() throws IOException {
        return this.ls(null);
    }

    public void mkdir() throws IOException {
        this.checkSmbFile(true);
        this.file.mkdir();
    }

    public void copyRemotelyTo(AbstractFile destFile) throws IOException {
        this.checkCopyRemotelyPrerequisites(destFile, false, false);
        SmbFile destSmbFile = ((SMBFile)destFile).file;
        this.file.copyTo(destSmbFile);
        ((SMBFile)destFile).checkSmbFile(this.file.isDirectory());
    }

    public void renameTo(AbstractFile destFile) throws IOException {
        this.checkRenamePrerequisites(destFile, true, true);
        boolean isDirectory = this.file.isDirectory();
        if (destFile.exists()) {
            destFile.delete();
        }
        this.file.renameTo(((SMBFile)destFile).file);
        ((SMBFile)destFile).checkSmbFile(isDirectory);
    }

    public long getFreeSpace() throws IOException {
        return this.file.getDiskFreeSpace();
    }

    @UnsupportedFileOperation
    public long getTotalSpace() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.GET_TOTAL_SPACE);
    }

    public Object getUnderlyingFileObject() {
        return this.file;
    }

    public AbstractFile[] ls(FilenameFilter filenameFilter) throws IOException {
        try {
            int smbFileType;
            SmbFile[] smbFiles = this.file.listFiles(filenameFilter == null ? null : new SMBFilenameFilter(filenameFilter));
            if (smbFiles == null) {
                throw new IOException();
            }
            int nbSmbFiles = smbFiles.length;
            int nbSmbFilesToExclude = 0;
            for (int i = 0; i < nbSmbFiles; ++i) {
                smbFileType = smbFiles[i].getType();
                if (smbFileType != 32 && smbFileType != 16 && smbFileType != 64) continue;
                ++nbSmbFilesToExclude;
            }
            AbstractFile[] children = new AbstractFile[nbSmbFiles - nbSmbFilesToExclude];
            int currentIndex = 0;
            for (int i = 0; i < nbSmbFiles; ++i) {
                SmbFile smbFile = smbFiles[i];
                smbFileType = smbFile.getType();
                if (smbFileType == 32 || smbFileType == 16 || smbFileType == 64) continue;
                FileURL childURL = (FileURL)this.fileURL.clone();
                childURL.setHost(smbFile.getServer());
                childURL.setPath(smbFile.getURL().getPath());
                children[currentIndex++] = FileFactory.getFile(childURL, (AbstractFile)this, smbFile);
            }
            return children;
        }
        catch (SmbAuthException e) {
            throw new AuthException(this.fileURL, e.getMessage());
        }
    }

    public boolean isHidden() {
        try {
            return this.file.isHidden();
        }
        catch (SmbException e) {
            return false;
        }
    }

    public boolean equalsCanonical(Object f) {
        if (!(f instanceof SMBFile)) {
            return super.equalsCanonical(f);
        }
        return this.file.equals(((SMBFile)f).file);
    }

    private static class SMBFilenameFilter
    implements SmbFilenameFilter {
        private FilenameFilter filter;

        private SMBFilenameFilter(FilenameFilter filter) {
            this.filter = filter;
        }

        public boolean accept(SmbFile dir, String name) throws SmbException {
            return this.filter.accept(name);
        }
    }

    private static class SMBFilePermissions
    extends IndividualPermissionBits
    implements FilePermissions {
        private SmbFile file;
        private static final PermissionBits MASK = new GroupedPermissionBits(384);

        public SMBFilePermissions(SmbFile file) {
            this.file = file;
        }

        public boolean getBitValue(int access, int type) {
            if (access != 2) {
                return false;
            }
            try {
                if (type == 4) {
                    return this.file.canRead();
                }
                if (type == 2) {
                    return this.file.canWrite();
                }
                return false;
            }
            catch (SmbException e) {
                return false;
            }
        }

        public PermissionBits getMask() {
            return MASK;
        }
    }

    public static class SMBRandomAccessOutputStream
    extends RandomAccessOutputStream {
        private SmbRandomAccessFile raf;

        public SMBRandomAccessOutputStream(SmbRandomAccessFile raf) {
            this.raf = raf;
        }

        public void write(int i) throws IOException {
            this.raf.write(i);
        }

        public void write(byte[] b) throws IOException {
            this.raf.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.raf.write(b, off, len);
        }

        public void close() throws IOException {
            this.raf.close();
        }

        public long getOffset() throws IOException {
            return this.raf.getFilePointer();
        }

        public long getLength() throws IOException {
            return this.raf.length();
        }

        public void seek(long offset) throws IOException {
            this.raf.seek(offset);
        }

        public void setLength(long newLength) throws IOException {
            this.raf.setLength(newLength);
            if (this.getOffset() > newLength) {
                this.raf.seek(newLength);
            }
        }
    }

    public static class SMBRandomAccessInputStream
    extends RandomAccessInputStream {
        private SmbRandomAccessFile raf;

        public SMBRandomAccessInputStream(SmbRandomAccessFile raf) {
            this.raf = raf;
        }

        public int read() throws IOException {
            return this.raf.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.raf.read(b, off, len);
        }

        public void close() throws IOException {
            this.raf.close();
        }

        public long getOffset() throws IOException {
            return this.raf.getFilePointer();
        }

        public long getLength() throws IOException {
            return this.raf.length();
        }

        public void seek(long offset) throws IOException {
            this.raf.seek(offset);
        }
    }
}

