/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.tar.provider;

import com.mucommander.commons.file.impl.tar.provider.TarUtils;
import java.util.Date;

public class TarEntry {
    private StringBuffer name;
    private int mode;
    private int userId;
    private int groupId;
    private long size;
    private long modTime;
    private byte linkFlag;
    private StringBuffer linkName;
    private StringBuffer magic = new StringBuffer("ustar");
    private StringBuffer userName;
    private StringBuffer groupName;
    private int devMajor;
    private int devMinor;
    private long offset;

    private TarEntry() {
        this.name = new StringBuffer();
        this.linkName = new StringBuffer();
        String user = System.getProperty("user.name", "");
        if (user.length() > 31) {
            user = user.substring(0, 31);
        }
        this.userId = 0;
        this.groupId = 0;
        this.userName = new StringBuffer(user);
        this.groupName = new StringBuffer("");
    }

    public TarEntry(String name) {
        this();
        boolean isDir = name.endsWith("/");
        this.devMajor = 0;
        this.devMinor = 0;
        this.name = new StringBuffer(name);
        this.mode = isDir ? 16877 : 33188;
        this.linkFlag = (byte)(isDir ? 53 : 48);
        this.userId = 0;
        this.groupId = 0;
        this.size = 0L;
        this.modTime = new Date().getTime() / 1000L;
        this.linkName = new StringBuffer("");
        this.userName = new StringBuffer("");
        this.groupName = new StringBuffer("");
        this.devMajor = 0;
        this.devMinor = 0;
    }

    public TarEntry(String name, byte linkFlag) {
        this(name);
        this.linkFlag = linkFlag;
    }

    public TarEntry(byte[] headerBuf) {
        this();
        this.parseTarHeader(headerBuf);
    }

    public boolean equals(TarEntry it) {
        return this.getName().equals(it.getName());
    }

    public boolean equals(Object it) {
        if (it == null || this.getClass() != it.getClass()) {
            return false;
        }
        return this.equals((TarEntry)it);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getName() {
        return this.name.toString();
    }

    public void setName(String name) {
        this.name = new StringBuffer(name);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public String getUserName() {
        return this.userName.toString();
    }

    public String getGroupName() {
        return this.groupName.toString();
    }

    public void setModTime(long time) {
        this.modTime = time / 1000L;
    }

    public Date getModTime() {
        return new Date(this.modTime * 1000L);
    }

    public int getMode() {
        return this.mode;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean isGNULongNameEntry() {
        return this.linkFlag == 76 && this.name.toString().equals("././@LongLink");
    }

    public boolean isDirectory() {
        if (this.linkFlag == 53) {
            return true;
        }
        return this.getName().endsWith("/");
    }

    public void writeEntryHeader(byte[] outbuf) {
        int offset = 0;
        offset = TarUtils.getNameBytes(this.name, outbuf, offset, 100);
        offset = TarUtils.getOctalBytes(this.mode, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.userId, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.groupId, outbuf, offset, 8);
        offset = TarUtils.getLongOctalBytes(this.size, outbuf, offset, 12);
        int csOffset = offset = TarUtils.getLongOctalBytes(this.modTime, outbuf, offset, 12);
        for (int c = 0; c < 8; ++c) {
            outbuf[offset++] = 32;
        }
        outbuf[offset++] = this.linkFlag;
        offset = TarUtils.getNameBytes(this.linkName, outbuf, offset, 100);
        offset = TarUtils.getNameBytes(this.magic, outbuf, offset, 8);
        offset = TarUtils.getNameBytes(this.userName, outbuf, offset, 32);
        offset = TarUtils.getNameBytes(this.groupName, outbuf, offset, 32);
        offset = TarUtils.getOctalBytes(this.devMajor, outbuf, offset, 8);
        offset = TarUtils.getOctalBytes(this.devMinor, outbuf, offset, 8);
        while (offset < outbuf.length) {
            outbuf[offset++] = 0;
        }
        long chk = TarUtils.computeCheckSum(outbuf);
        TarUtils.getCheckSumOctalBytes(chk, outbuf, csOffset, 8);
    }

    public void parseTarHeader(byte[] header) {
        int offset = 0;
        this.name = TarUtils.parseName(header, offset, 100);
        this.mode = (int)TarUtils.parseOctal(header, offset += 100, 8);
        this.userId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.groupId = (int)TarUtils.parseOctal(header, offset += 8, 8);
        this.size = TarUtils.parseOctal(header, offset += 8, 12);
        this.modTime = TarUtils.parseOctal(header, offset += 12, 12);
        offset += 12;
        offset += 8;
        this.linkFlag = header[offset++];
        this.linkName = TarUtils.parseName(header, offset, 100);
        this.magic = TarUtils.parseName(header, offset += 100, 8);
        this.userName = TarUtils.parseName(header, offset += 8, 32);
        this.groupName = TarUtils.parseName(header, offset += 32, 32);
        this.devMajor = (int)TarUtils.parseOctal(header, offset += 32, 8);
        this.devMinor = (int)TarUtils.parseOctal(header, offset += 8, 8);
    }
}

