/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractRWArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.zip.JavaUtilZipEntryIterator;
import com.mucommander.commons.file.impl.zip.provider.ZipEntry;
import com.mucommander.commons.file.impl.zip.provider.ZipFile;
import com.mucommander.commons.io.FilteredOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipInputStream;

public class ZipArchiveFile
extends AbstractRWArchiveFile {
    private ZipFile zipFile;
    private long lastZipFileDate;
    private static final byte[] EMPTY_ZIP_BYTES = new byte[]{80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public ZipArchiveFile(AbstractFile file) {
        super(file);
    }

    private void checkZipFile() throws IOException, UnsupportedFileOperationException {
        long currentDate = this.file.getDate();
        if (this.zipFile == null || currentDate != this.lastZipFileDate) {
            this.zipFile = new ZipFile(this.file);
            this.declareZipFileUpToDate();
        }
    }

    private void declareZipFileUpToDate() {
        this.lastZipFileDate = this.file.getDate();
    }

    private ZipEntry createZipEntry(ArchiveEntry entry) {
        boolean isDirectory = entry.isDirectory();
        String path = entry.getPath();
        if (isDirectory && !path.endsWith("/")) {
            path = path + "/";
        }
        ZipEntry zipEntry = new ZipEntry(path);
        zipEntry.setMethod(8);
        zipEntry.setTime(System.currentTimeMillis());
        zipEntry.setUnixMode(SimpleFilePermissions.padPermissions(entry.getPermissions(), isDirectory ? FilePermissions.DEFAULT_DIRECTORY_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS).getIntValue());
        return zipEntry;
    }

    static ArchiveEntry createArchiveEntry(ZipEntry zipEntry) {
        ArchiveEntry entry = new ArchiveEntry(zipEntry.getName(), zipEntry.isDirectory(), zipEntry.getTime(), zipEntry.getSize(), true);
        if (zipEntry.hasUnixMode()) {
            entry.setPermissions(new SimpleFilePermissions(zipEntry.getUnixMode()));
        }
        entry.setEntryObject(zipEntry);
        return entry;
    }

    private void finishAddEntry(ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        this.declareZipFileUpToDate();
        this.declareEntriesTreeUpToDate();
        this.addToEntriesTree(entry);
    }

    public synchronized ArchiveEntryIterator getEntryIterator() throws IOException, UnsupportedFileOperationException {
        if (this.file.isFileOperationSupported(FileOperation.RANDOM_READ_FILE)) {
            this.checkZipFile();
            final Iterator<ZipEntry> iterator = this.zipFile.getEntries();
            return new ArchiveEntryIterator(){

                public ArchiveEntry nextEntry() throws IOException {
                    ZipEntry entry;
                    if (!iterator.hasNext() || (entry = (ZipEntry)iterator.next()) == null) {
                        return null;
                    }
                    return ZipArchiveFile.createArchiveEntry(entry);
                }

                public void close() throws IOException {
                }
            };
        }
        return new JavaUtilZipEntryIterator(new ZipInputStream(this.file.getInputStream()));
    }

    public synchronized InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        java.util.zip.ZipEntry zipEntry;
        ArchiveEntry currentEntry;
        if (this.file.isFileOperationSupported(FileOperation.RANDOM_READ_FILE)) {
            this.checkZipFile();
            ZipEntry zipEntry2 = (ZipEntry)entry.getEntryObject();
            if (zipEntry2 == null) {
                throw new IOException();
            }
            return this.zipFile.getInputStream(zipEntry2);
        }
        if (entryIterator != null && entryIterator instanceof JavaUtilZipEntryIterator && (currentEntry = ((JavaUtilZipEntryIterator)entryIterator).getCurrentEntry()).getPath().equals(entry.getPath())) {
            return new FilterInputStream(((JavaUtilZipEntryIterator)entryIterator).getZipInputStream()){

                public void close() throws IOException {
                }
            };
        }
        ZipInputStream zin = new ZipInputStream(this.file.getInputStream());
        String entryPath = entry.getPath();
        while ((zipEntry = zin.getNextEntry()) != null) {
            if (!zipEntry.getName().equals(entryPath)) continue;
            return zin;
        }
        throw new IOException("Unknown Zip entry: " + entry.getName());
    }

    public synchronized OutputStream addEntry(final ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        this.checkZipFile();
        ZipEntry zipEntry = this.createZipEntry(entry);
        if (zipEntry.isDirectory()) {
            this.zipFile.addEntry(zipEntry);
            entry.setEntryObject(zipEntry);
            this.finishAddEntry(entry);
            return null;
        }
        entry.setEntryObject(zipEntry);
        return new FilteredOutputStream(this.zipFile.addEntry(zipEntry)){

            public void close() throws IOException {
                super.close();
                ZipArchiveFile.this.finishAddEntry(entry);
            }
        };
    }

    public synchronized void deleteEntry(ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        ZipEntry zipEntry = (ZipEntry)entry.getEntryObject();
        if (zipEntry != null) {
            this.checkZipFile();
            this.zipFile.deleteEntry(zipEntry);
            entry.setEntryObject(null);
            this.declareZipFileUpToDate();
            this.declareEntriesTreeUpToDate();
        }
        this.removeFromEntriesTree(entry);
    }

    public void updateEntry(ArchiveEntry entry) throws IOException, UnsupportedFileOperationException {
        ZipEntry zipEntry = (ZipEntry)entry.getEntryObject();
        if (zipEntry != null) {
            this.checkZipFile();
            zipEntry.setTime(entry.getDate());
            zipEntry.setUnixMode(entry.getPermissions().getIntValue());
            this.zipFile.updateEntry(zipEntry);
            this.declareZipFileUpToDate();
            this.declareEntriesTreeUpToDate();
        }
    }

    public synchronized void optimizeArchive() throws IOException, UnsupportedFileOperationException {
        this.checkZipFile();
        this.zipFile.defragment();
        this.declareZipFileUpToDate();
        this.declareEntriesTreeUpToDate();
    }

    public boolean isWritable() {
        return this.file.isFileOperationSupported(FileOperation.RANDOM_READ_FILE) && this.file.isFileOperationSupported(FileOperation.RANDOM_WRITE_FILE);
    }

    public void mkfile() throws IOException, UnsupportedFileOperationException {
        if (this.exists()) {
            throw new IOException();
        }
        this.copyStream(new ByteArrayInputStream(EMPTY_ZIP_BYTES), false, EMPTY_ZIP_BYTES.length);
    }
}

