/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.impl.zip.provider.ZipExtraField;
import com.mucommander.commons.file.impl.zip.provider.ZipLong;
import com.mucommander.commons.file.impl.zip.provider.ZipShort;
import java.util.zip.CRC32;
import java.util.zip.ZipException;

public class AsiExtraField
implements ZipExtraField,
Cloneable {
    private static final ZipShort HEADER_ID = new ZipShort(30062);
    private int mode = 0;
    private int uid = 0;
    private int gid = 0;
    private String link = "";
    private boolean dirFlag = false;
    private CRC32 crc = new CRC32();

    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    public ZipShort getLocalFileDataLength() {
        return new ZipShort(14 + this.getLinkedFile().getBytes().length);
    }

    public ZipShort getCentralDirectoryLength() {
        return this.getLocalFileDataLength();
    }

    public byte[] getLocalFileDataData() {
        byte[] data = new byte[this.getLocalFileDataLength().getValue() - 4];
        ZipShort.getBytes(this.getMode(), data, 0);
        byte[] linkArray = this.getLinkedFile().getBytes();
        ZipLong.getBytes(linkArray.length, data, 2);
        ZipShort.getBytes(this.getUserId(), data, 6);
        ZipShort.getBytes(this.getGroupId(), data, 8);
        System.arraycopy(linkArray, 0, data, 10, linkArray.length);
        this.crc.reset();
        this.crc.update(data);
        long checksum = this.crc.getValue();
        byte[] result = new byte[data.length + 4];
        ZipLong.getBytes(checksum, result, 0);
        System.arraycopy(data, 0, result, 4, data.length);
        return result;
    }

    public byte[] getCentralDirectoryData() {
        return this.getLocalFileDataData();
    }

    public int getUserId() {
        return this.uid;
    }

    public int getGroupId() {
        return this.gid;
    }

    public String getLinkedFile() {
        return this.link;
    }

    public boolean isLink() {
        return this.getLinkedFile().length() != 0;
    }

    public void setMode(int mode) {
        this.mode = this.getMode(mode);
    }

    public int getMode() {
        return this.mode;
    }

    public void setDirectory(boolean dirFlag) {
        this.dirFlag = dirFlag;
        this.mode = this.getMode(this.mode);
    }

    public boolean isDirectory() {
        return this.dirFlag && !this.isLink();
    }

    public void parseFromLocalFileData(byte[] data, int offset, int length) throws ZipException {
        long givenChecksum = ZipLong.getValue(data, offset);
        byte[] tmp = new byte[length - 4];
        System.arraycopy(data, offset + 4, tmp, 0, length - 4);
        this.crc.reset();
        this.crc.update(tmp);
        long realChecksum = this.crc.getValue();
        if (givenChecksum != realChecksum) {
            throw new ZipException("bad CRC checksum " + Long.toHexString(givenChecksum) + " instead of " + Long.toHexString(realChecksum));
        }
        int newMode = ZipShort.getValue(tmp, 0);
        byte[] linkArray = new byte[(int)ZipLong.getValue(tmp, 2)];
        this.uid = ZipShort.getValue(tmp, 6);
        this.gid = ZipShort.getValue(tmp, 8);
        if (linkArray.length == 0) {
            this.link = "";
        } else {
            System.arraycopy(tmp, 10, linkArray, 0, linkArray.length);
            this.link = new String(linkArray);
        }
        this.setDirectory((newMode & 0x4000) != 0);
        this.setMode(newMode);
    }

    protected int getMode(int mode) {
        int type = 32768;
        if (this.isLink()) {
            type = 40960;
        } else if (this.isDirectory()) {
            type = 16384;
        }
        return type | mode & 0xFFF;
    }
}

