/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.impl.zip.provider.ZipEntryOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflatedOutputStream
extends ZipEntryOutputStream {
    protected Deflater deflater;
    protected byte[] buf;

    public DeflatedOutputStream(OutputStream out, Deflater deflater, byte[] buf) {
        super(out, 8);
        this.deflater = deflater;
        this.buf = buf;
        deflater.reset();
    }

    protected void deflate() throws IOException {
        int len = this.deflater.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.out.write(this.buf, 0, len);
        }
    }

    public void finishDeflate() throws IOException {
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate();
        }
    }

    public int getTotalIn() {
        return this.deflater.getTotalIn();
    }

    public int getTotalOut() {
        return this.deflater.getTotalOut();
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        if (length > 0 && !this.deflater.finished()) {
            this.deflater.setInput(b, offset, length);
            while (!this.deflater.needsInput()) {
                this.deflate();
            }
        }
        this.crc.update(b, offset, length);
    }

    public void close() throws IOException {
        this.finishDeflate();
    }
}

