/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.impl.zip.provider.AsiExtraField;
import com.mucommander.commons.file.impl.zip.provider.JarMarker;
import com.mucommander.commons.file.impl.zip.provider.UnrecognizedExtraField;
import com.mucommander.commons.file.impl.zip.provider.ZipExtraField;
import com.mucommander.commons.file.impl.zip.provider.ZipShort;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtraFieldUtils {
    private static Hashtable<ZipShort, Class<? extends ZipExtraField>> implementations = new Hashtable();

    public static void register(Class<? extends ZipExtraField> c) {
        try {
            ZipExtraField ze = c.newInstance();
            implementations.put(ze.getHeaderId(), c);
        }
        catch (ClassCastException cc) {
            throw new RuntimeException(c + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(c + " is not a concrete class");
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(c + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort headerId) throws InstantiationException, IllegalAccessException {
        Class<? extends ZipExtraField> c = implementations.get(headerId);
        if (c != null) {
            return c.newInstance();
        }
        UnrecognizedExtraField u = new UnrecognizedExtraField();
        u.setHeaderId(headerId);
        return u;
    }

    public static ZipExtraField[] parse(byte[] data) throws ZipException {
        int start;
        int length;
        Vector<ZipExtraField> v = new Vector<ZipExtraField>();
        for (start = 0; start <= data.length - 4; start += length + 4) {
            ZipShort headerId = new ZipShort(data, start);
            length = new ZipShort(data, start + 2).getValue();
            if (start + 4 + length > data.length) {
                throw new ZipException("data starting at " + start + " is in unknown format");
            }
            try {
                ZipExtraField ze = ExtraFieldUtils.createExtraField(headerId);
                ze.parseFromLocalFileData(data, start + 4, length);
                v.addElement(ze);
                continue;
            }
            catch (InstantiationException ie) {
                throw new ZipException(ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new ZipException(iae.getMessage());
            }
        }
        if (start != data.length) {
            throw new ZipException("data starting at " + start + " is in unknown format");
        }
        Object[] result = new ZipExtraField[v.size()];
        v.copyInto(result);
        return result;
    }

    public static byte[] mergeLocalExtraFields(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (ZipExtraField d : data) {
            sum += d.getLocalFileDataLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (ZipExtraField d : data) {
            System.arraycopy(d.getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(d.getLocalFileDataLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = d.getLocalFileDataData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    public static byte[] mergeCentralExtraFields(ZipExtraField[] data) {
        int sum = 4 * data.length;
        for (ZipExtraField d : data) {
            sum += d.getCentralDirectoryLength().getValue();
        }
        byte[] result = new byte[sum];
        int start = 0;
        for (ZipExtraField d : data) {
            System.arraycopy(d.getHeaderId().getBytes(), 0, result, start, 2);
            System.arraycopy(d.getCentralDirectoryLength().getBytes(), 0, result, start + 2, 2);
            byte[] local = d.getCentralDirectoryData();
            System.arraycopy(local, 0, result, start + 4, local.length);
            start += local.length + 4;
        }
        return result;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(JarMarker.class);
    }
}

