/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.impl.zip.provider.ExtraFieldUtils;
import com.mucommander.commons.file.impl.zip.provider.ZipEntryInfo;
import com.mucommander.commons.file.impl.zip.provider.ZipExtraField;
import java.util.Calendar;
import java.util.Vector;
import java.util.zip.ZipException;

public class ZipEntry
implements Cloneable {
    protected String name = null;
    protected long size = -1L;
    protected long compressedSize = -1L;
    protected long crc = -1L;
    protected long dosTime = -1L;
    protected long javaTime = -1L;
    protected int method = -1;
    protected String comment;
    protected int platform = 0;
    protected int internalAttributes = 0;
    protected long externalAttributes = 0L;
    protected Vector<ZipExtraField> extraFields = null;
    protected ZipEntryInfo entryInfo;
    protected static final Calendar CALENDAR = Calendar.getInstance();

    public ZipEntry() {
        this("");
    }

    public ZipEntry(String name) {
        this.name = name;
    }

    public ZipEntry(java.util.zip.ZipEntry entry) throws ZipException {
        this.name = entry.getName();
        this.crc = entry.getCrc();
        this.size = entry.getSize();
        this.compressedSize = entry.getCompressedSize();
        this.method = entry.getMethod();
        this.comment = entry.getComment();
        this.setExtra(entry.getExtra());
        this.setTime(entry.getTime());
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public void setUnixMode(int mode) {
        boolean isDirectory = this.isDirectory();
        this.setExternalAttributes((isDirectory ? 16384 : 32768) << 16 | mode << 16 | ((mode & 0x80) == 0 ? 1 : 0) | (isDirectory ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public boolean hasUnixMode() {
        return this.getPlatform() == 3;
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int platform) {
        this.platform = platform;
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.extraFields = new Vector();
        for (ZipExtraField field : fields) {
            this.extraFields.addElement(field);
        }
    }

    public ZipExtraField[] getExtraFields() {
        if (this.extraFields == null) {
            return new ZipExtraField[0];
        }
        Object[] result = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(result);
        return result;
    }

    public byte[] getLocalFileDataExtra() {
        return ExtraFieldUtils.mergeLocalExtraFields(this.getExtraFields());
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralExtraFields(this.getExtraFields());
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected ZipEntryInfo getEntryInfo() {
        return this.entryInfo;
    }

    protected void setEntryInfo(ZipEntryInfo entryInfo) {
        this.entryInfo = entryInfo;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        if (!this.isValidUnsignedInt(size)) {
            throw new IllegalArgumentException("Invalid entry size");
        }
        this.size = size;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long csize) {
        if (!this.isValidUnsignedInt(csize)) {
            throw new IllegalArgumentException("Invalid entry size");
        }
        this.compressedSize = csize;
    }

    public long getCrc() {
        return this.crc;
    }

    public void setCrc(long crc) {
        if (!this.isValidUnsignedInt(crc)) {
            throw new IllegalArgumentException("invalid entry crc-32");
        }
        this.crc = crc;
    }

    public long getTime() {
        return this.javaTime;
    }

    public void setTime(long javaTime) {
        this.javaTime = javaTime;
        this.dosTime = javaTime == -1L ? -1L : ZipEntry.javaToDosTime(javaTime);
    }

    protected long getDosTime() {
        return this.dosTime;
    }

    protected void setDosTime(long dosTime) {
        this.dosTime = dosTime;
        this.javaTime = dosTime == -1L ? -1L : ZipEntry.dosToJavaTime(dosTime);
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        if (method != 0 && method != 8) {
            throw new IllegalArgumentException("Invalid compression method");
        }
        this.method = method;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 21845 && ZipEntry.getUTF8Length(comment) > 65535) {
            throw new IllegalArgumentException("invalid entry comment length");
        }
        this.comment = comment;
    }

    public void setExtra(byte[] extra) throws IllegalArgumentException {
        if (extra == null || extra.length == 0) {
            this.extraFields = null;
        } else {
            try {
                this.setExtraFields(ExtraFieldUtils.parse(extra));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long dosToJavaTime(long dosTime) {
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
            CALENDAR.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
            CALENDAR.set(5, (int)(dosTime >> 16) & 0x1F);
            CALENDAR.set(11, (int)(dosTime >> 11) & 0x1F);
            CALENDAR.set(12, (int)(dosTime >> 5) & 0x3F);
            CALENDAR.set(13, (int)(dosTime << 1) & 0x3E);
            return CALENDAR.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long javaToDosTime(long javaTime) {
        Calendar calendar = CALENDAR;
        synchronized (calendar) {
            CALENDAR.setTimeInMillis(javaTime);
            int year = CALENDAR.get(1);
            if (year < 1980) {
                return 8448L;
            }
            return year - 1980 << 25 | CALENDAR.get(2) + 1 << 21 | CALENDAR.get(5) << 16 | CALENDAR.get(11) << 11 | CALENDAR.get(12) << 5 | CALENDAR.get(13) >> 1;
        }
    }

    protected static int getUTF8Length(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        return count;
    }

    protected boolean isValidUnsignedInt(long l) {
        return l >= 0L && l <= 0xFFFFFFFFL;
    }

    public Object clone() throws CloneNotSupportedException {
        ZipEntry ze = (ZipEntry)super.clone();
        if (this.extraFields != null) {
            ze.extraFields = (Vector)this.extraFields.clone();
        }
        return ze;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ZipEntry && ((ZipEntry)o).getName().equals(this.getName());
    }
}

