/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

import com.mucommander.commons.file.impl.zip.provider.DeflatedOutputStream;
import com.mucommander.commons.file.impl.zip.provider.StoredOutputStream;
import com.mucommander.commons.file.impl.zip.provider.ZipBuffer;
import com.mucommander.commons.file.impl.zip.provider.ZipConstants;
import com.mucommander.commons.file.impl.zip.provider.ZipEntry;
import com.mucommander.commons.file.impl.zip.provider.ZipEntryInfo;
import com.mucommander.commons.file.impl.zip.provider.ZipEntryOutputStream;
import com.mucommander.commons.file.impl.zip.provider.ZipLong;
import com.mucommander.commons.file.impl.zip.provider.ZipShort;
import com.mucommander.commons.io.BufferPool;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class ZipOutputStream
extends OutputStream
implements ZipConstants {
    private ZipEntry entry;
    private ZipEntryOutputStream zeos;
    private ZipEntryInfo entryInfo;
    private String comment = "";
    private int level = -1;
    private int method = 8;
    protected Deflater deflater = new Deflater(this.level, true);
    protected byte[] deflaterBuf;
    private Vector<ZipEntry> entries = new Vector();
    private long written = 0L;
    private String encoding = "UTF-8";
    private ZipBuffer zipBuffer = new ZipBuffer();
    private static final byte[] SHORT_0 = ZipShort.getBytes(0);
    private static final byte[] LONG_0 = ZipLong.getBytes(0L);
    private static final byte[] LONG_TRIPLE_0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHORT_8 = ZipShort.getBytes(8);
    private static final byte[] SHORT_10 = ZipShort.getBytes(10);
    private static final byte[] SHORT_20 = ZipShort.getBytes(20);
    private static final byte[] SHORT_2048 = ZipShort.getBytes(2048);
    private static final byte[] SHORT_2056 = ZipShort.getBytes(2056);
    protected OutputStream out;
    private boolean hasRandomAccess;

    public ZipOutputStream(OutputStream out) {
        this.out = out;
        this.hasRandomAccess = out instanceof RandomAccessOutputStream;
        this.deflaterBuf = BufferPool.getByteArray(512);
    }

    private static boolean isUTF8(String encoding) {
        return encoding == null || encoding.equalsIgnoreCase("UTF-8") || encoding.equalsIgnoreCase("UTF8");
    }

    public void finish() throws IOException {
        this.closeEntry();
        long cdOffset = this.written;
        int nbEntries = this.entries.size();
        for (int i = 0; i < nbEntries; ++i) {
            ZipEntry ze = this.entries.elementAt(i);
            this.written += ZipOutputStream.writeCentralFileHeader(ze, this.out, this.encoding, ze.getEntryInfo().headerOffset, !this.hasRandomAccess, this.zipBuffer);
        }
        long cdLength = this.written - cdOffset;
        ZipOutputStream.writeCentralDirectoryEnd(this.out, nbEntries, cdLength, cdOffset, this.comment, this.encoding, this.zipBuffer);
        this.entries.removeAllElements();
    }

    public void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        ZipOutputStream.finalizeEntryData(this.entry, this.zeos, this.out, !this.hasRandomAccess, this.zipBuffer);
        this.written += this.entry.getCompressedSize();
        if (!this.hasRandomAccess) {
            this.written += ZipOutputStream.writeDataDescriptor(this.entry, this.out, this.zipBuffer);
        }
        this.entry = null;
        this.entryInfo = null;
        this.zeos.close();
        this.zeos = null;
    }

    protected static void finalizeEntryData(ZipEntry entry, ZipEntryOutputStream zeos, OutputStream out, boolean useDataDescriptor, ZipBuffer zipBuffer) throws IOException {
        long crc = zeos.getCrc();
        if (entry.getMethod() == 8) {
            ((DeflatedOutputStream)zeos).finishDeflate();
            entry.setSize(ZipOutputStream.adjustToLong(zeos.getTotalIn()));
            long compressedSize = ZipOutputStream.adjustToLong(zeos.getTotalOut());
            entry.setCompressedSize(compressedSize);
            entry.setCrc(crc);
        } else {
            long size = zeos.getTotalOut();
            entry.setSize(size);
            entry.setCompressedSize(size);
            entry.setCrc(crc);
        }
        if (!useDataDescriptor) {
            RandomAccessOutputStream raos = (RandomAccessOutputStream)out;
            long save = raos.getOffset();
            raos.seek(entry.getEntryInfo().headerOffset + 14L);
            raos.write(ZipLong.getBytes(entry.getCrc(), zipBuffer.longBuffer));
            raos.write(ZipLong.getBytes(entry.getCompressedSize(), zipBuffer.longBuffer));
            raos.write(ZipLong.getBytes(entry.getSize(), zipBuffer.longBuffer));
            raos.seek(save);
        }
    }

    public void putNextEntry(ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entryInfo = new ZipEntryInfo();
        this.entry.setEntryInfo(this.entryInfo);
        this.entries.addElement(this.entry);
        int entryMethod = this.entry.getMethod();
        if (entryMethod == -1) {
            entryMethod = this.method;
            this.entry.setMethod(this.method);
        }
        if (this.entry.getTime() == -1L) {
            this.entry.setTime(System.currentTimeMillis());
        }
        if (entryMethod == 8) {
            this.deflater.reset();
            this.deflater.setLevel(this.level);
            this.zeos = new DeflatedOutputStream(this.out, this.deflater, this.deflaterBuf);
        } else {
            this.zeos = new StoredOutputStream(this.out);
        }
        this.entryInfo.headerOffset = this.written;
        this.written += ZipOutputStream.writeLocalFileHeader(this.entry, this.out, this.encoding, !this.hasRandomAccess, this.zipBuffer);
        this.entryInfo.dataOffset = this.written;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    protected static long writeLocalFileHeader(ZipEntry ze, OutputStream out, String encoding, boolean useDataDescriptor, ZipBuffer zipBuffer) throws IOException {
        out.write(LFH_SIG);
        int zipMethod = ze.getMethod();
        ZipOutputStream.writeVersionAndGPBF(out, encoding, useDataDescriptor);
        out.write(ZipShort.getBytes(zipMethod, zipBuffer.shortBuffer));
        out.write(ZipLong.getBytes(ze.getDosTime(), zipBuffer.longBuffer));
        out.write(LONG_TRIPLE_0);
        byte[] name = ZipOutputStream.getBytes(ze.getName(), encoding);
        out.write(ZipShort.getBytes(name.length, zipBuffer.shortBuffer));
        byte[] extra = ze.getLocalFileDataExtra();
        out.write(ZipShort.getBytes(extra.length, zipBuffer.shortBuffer));
        long written = 30L;
        out.write(name);
        written += (long)name.length;
        out.write(extra);
        return written += (long)extra.length;
    }

    protected static long writeDataDescriptor(ZipEntry ze, OutputStream out, ZipBuffer zipBuffer) throws IOException {
        out.write(DD_SIG);
        out.write(ZipLong.getBytes(ze.getCrc(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(ze.getCompressedSize(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(ze.getSize(), zipBuffer.longBuffer));
        return 16L;
    }

    protected static long writeVersionMadeBy(ZipEntry ze, OutputStream out, ZipBuffer zipBuffer) throws IOException {
        out.write(ZipShort.getBytes(ze.getPlatform() << 8 | 0x14, zipBuffer.shortBuffer));
        return 2L;
    }

    protected static long writeCentralFileHeader(ZipEntry ze, OutputStream out, String encoding, long localFileHeaderOffset, boolean useDataDescriptor, ZipBuffer zipBuffer) throws IOException {
        out.write(CFH_SIG);
        ZipOutputStream.writeVersionMadeBy(ze, out, zipBuffer);
        ZipOutputStream.writeVersionAndGPBF(out, encoding, useDataDescriptor);
        out.write(ZipShort.getBytes(ze.getMethod(), zipBuffer.shortBuffer));
        out.write(ZipLong.getBytes(ze.getDosTime(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(ze.getCrc(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(ze.getCompressedSize(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(ze.getSize(), zipBuffer.longBuffer));
        byte[] name = ZipOutputStream.getBytes(ze.getName(), encoding);
        out.write(ZipShort.getBytes(name.length, zipBuffer.shortBuffer));
        byte[] extra = ze.getCentralDirectoryExtra();
        out.write(ZipShort.getBytes(extra.length, zipBuffer.shortBuffer));
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] commentB = ZipOutputStream.getBytes(comm, encoding);
        out.write(ZipShort.getBytes(commentB.length, zipBuffer.shortBuffer));
        out.write(SHORT_0);
        out.write(ZipShort.getBytes(ze.getInternalAttributes(), zipBuffer.shortBuffer));
        out.write(ZipLong.getBytes(ze.getExternalAttributes(), zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(localFileHeaderOffset, zipBuffer.longBuffer));
        long nbWritten = 46L;
        out.write(name);
        nbWritten += (long)name.length;
        out.write(extra);
        nbWritten += (long)extra.length;
        out.write(commentB);
        return nbWritten += (long)commentB.length;
    }

    protected static long writeVersionAndGPBF(OutputStream out, String encoding, boolean useDataDescriptor) throws IOException {
        boolean isUTF8 = ZipOutputStream.isUTF8(encoding);
        if (useDataDescriptor) {
            out.write(SHORT_20);
            out.write(isUTF8 ? SHORT_2056 : SHORT_8);
        } else {
            out.write(SHORT_10);
            out.write(isUTF8 ? SHORT_2048 : SHORT_0);
        }
        return 4L;
    }

    protected static void writeCentralDirectoryEnd(OutputStream out, int nbEntries, long cdLength, long cdOffset, String comment, String encoding, ZipBuffer zipBuffer) throws IOException {
        out.write(EOCD_SIG);
        out.write(LONG_0);
        ZipShort.getBytes(nbEntries, zipBuffer.shortBuffer);
        out.write(zipBuffer.shortBuffer);
        out.write(zipBuffer.shortBuffer);
        out.write(ZipLong.getBytes(cdLength, zipBuffer.longBuffer));
        out.write(ZipLong.getBytes(cdOffset, zipBuffer.longBuffer));
        byte[] data = ZipOutputStream.getBytes(comment, encoding);
        out.write(ZipShort.getBytes(data.length, zipBuffer.shortBuffer));
        out.write(data);
    }

    protected static byte[] getBytes(String name, String encoding) throws ZipException {
        if (encoding == null) {
            return name.getBytes();
        }
        try {
            return name.getBytes(encoding);
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    protected static long adjustToLong(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        (this.zeos == null ? this.out : this.zeos).write(b, offset, length);
    }

    public void write(byte[] b) throws IOException {
        (this.zeos == null ? this.out : this.zeos).write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        (this.zeos == null ? this.out : this.zeos).write(b);
    }

    public void close() throws IOException {
        this.finish();
        if (this.deflaterBuf != null) {
            BufferPool.releaseByteArray(this.deflaterBuf);
            this.deflaterBuf = null;
        }
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }
}

