/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.zip.provider;

public final class ZipShort
implements Cloneable {
    private int value;

    public ZipShort(int value) {
        this.value = value;
    }

    public ZipShort(byte[] bytes, int offset) {
        this.value = ZipShort.getValue(bytes, offset);
    }

    public byte[] getBytes() {
        byte[] result = new byte[]{(byte)(this.value & 0xFF), (byte)((this.value & 0xFF00) >> 8)};
        return result;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int value) {
        return ZipShort.getBytes(value, new byte[2], 0);
    }

    public static byte[] getBytes(int value, byte[] result) {
        return ZipShort.getBytes(value, result, 0);
    }

    public static byte[] getBytes(int value, byte[] result, int off) {
        result[off] = (byte)(value & 0xFF);
        result[off + 1] = (byte)((value & 0xFF00) >> 8);
        return result;
    }

    public static int getValue(byte[] bytes, int offset) {
        int value = bytes[offset + 1] << 8 & 0xFF00;
        return value += bytes[offset] & 0xFF;
    }

    public static int getValue(byte[] bytes) {
        return ZipShort.getValue(bytes, 0);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o).getValue();
    }

    public int hashCode() {
        return this.value;
    }
}

