/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.util;

import com.mucommander.commons.file.AbstractFile;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComparator
implements Comparator<AbstractFile> {
    private int criterion;
    private boolean ascending;
    private boolean directoriesFirst;
    private static final Pattern FILENAME_WITH_NUMBER_PATTERN = Pattern.compile("\\d+");

    public FileComparator(int criterion, boolean ascending, boolean directoriesFirst) {
        this.criterion = criterion;
        this.ascending = ascending;
        this.directoriesFirst = directoriesFirst;
    }

    private int getCharacterValue(int c) {
        if (Character.isLetter(c)) {
            c += 131070;
        } else if (Character.isDigit(c)) {
            c += 65535;
        }
        return c;
    }

    private String removeLeadingZeros(String s) {
        int i;
        int len = s.length();
        for (i = 0; i < len && s.charAt(i) == '0'; ++i) {
        }
        if (i > 0) {
            return s.substring(i, len);
        }
        return s;
    }

    private int compareStrings(String s1, String s2, boolean ignoreCase, boolean nullProtection) {
        int start2;
        int start1;
        Matcher m2;
        Matcher m1;
        if (nullProtection) {
            if (s1 == null && s2 != null) {
                return -1;
            }
            if (s1 != null && s2 == null) {
                return 1;
            }
            if (s1 == null) {
                return 0;
            }
        }
        if ((m1 = FILENAME_WITH_NUMBER_PATTERN.matcher(s1)).find() && (m2 = FILENAME_WITH_NUMBER_PATTERN.matcher(s2)).find() && (start1 = m1.start()) == (start2 = m2.start()) && (start1 == 0 || s1.substring(0, start1).equals(s2.substring(0, start2)))) {
            int g2Len;
            String g1 = this.removeLeadingZeros(m1.group());
            String g2 = this.removeLeadingZeros(m2.group());
            int g1Len = g1.length();
            if (g1Len != (g2Len = g2.length())) {
                return g1Len - g2Len;
            }
            for (int i = 0; i < g1Len && i < g2Len; ++i) {
                char c2;
                char c1 = g1.charAt(i);
                if (c1 == (c2 = g2.charAt(i))) continue;
                return c1 - c2;
            }
        }
        int n1 = s1.length();
        int n2 = s2.length();
        for (int i = 0; i < n1 && i < n2; ++i) {
            int c1 = s1.charAt(i);
            int c2 = s2.charAt(i);
            if (!(ignoreCase ? c1 != c2 && (c1 = Character.toUpperCase(c1)) != (c2 = Character.toUpperCase(c2)) && (c1 = Character.toLowerCase(c1)) != (c2 = Character.toLowerCase(c2)) : c1 != c2)) continue;
            return this.getCharacterValue(c1) - this.getCharacterValue(c2);
        }
        return n1 - n2;
    }

    @Override
    public int compare(AbstractFile f1, AbstractFile f2) {
        long diff;
        boolean is1Directory = f1.isDirectory();
        boolean is2Directory = f2.isDirectory();
        if (this.directoriesFirst) {
            if (is1Directory && !is2Directory) {
                return -1;
            }
            if (is2Directory && !is1Directory) {
                return 1;
            }
        }
        if (this.criterion == 1) {
            long fileSize1 = is1Directory ? 0L : f1.getSize();
            long fileSize2 = is2Directory ? 0L : f2.getSize();
            diff = (fileSize1 == -1L ? Long.MAX_VALUE : fileSize1) - (fileSize2 == -1L ? Long.MAX_VALUE : fileSize2);
        } else if (this.criterion == 2) {
            diff = f1.getDate() - f2.getDate();
        } else if (this.criterion == 4) {
            diff = f1.getPermissions().getIntValue() - f2.getPermissions().getIntValue();
        } else if (this.criterion == 3) {
            diff = this.compareStrings(f1.getExtension(), f2.getExtension(), true, true);
        } else if (this.criterion == 5) {
            diff = this.compareStrings(f1.getOwner(), f2.getOwner(), true, true);
        } else if (this.criterion == 6) {
            diff = this.compareStrings(f1.getGroup(), f2.getGroup(), true, true);
        } else {
            diff = this.compareStrings(f1.getName(), f2.getName(), true, false);
            if (diff == 0L) {
                diff = this.compareStrings(f1.getName(), f2.getName(), false, false);
            }
        }
        if (this.criterion != 0 && diff == 0L) {
            diff = this.compareStrings(f1.getName(), f2.getName(), true, false);
        }
        int intValue = diff > Integer.MAX_VALUE ? Integer.MAX_VALUE : (diff < -2147483647L ? -2147483647 : (int)diff);
        return this.ascending ? intValue : -intValue;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FileComparator)) {
            return false;
        }
        FileComparator fc = (FileComparator)o;
        return this.criterion == fc.criterion && this.ascending == fc.ascending;
    }
}

