/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.util;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.io.StreamUtils;
import com.mucommander.commons.runtime.OsFamilies;
import com.mucommander.commons.runtime.OsVersions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSXFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSXFileUtils.class);
    private static final Pattern MDLS_COMMENT_PATTERN = Pattern.compile("\".*\"$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSpotlightComment(AbstractFile file) {
        if (!OsFamilies.MAC_OS_X.isCurrent()) return null;
        if (!OsVersions.MAC_OS_X_10_4.isCurrentOrHigher()) {
            return null;
        }
        InputStream pin = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"mdls", "-name", "kMDItemFinderComment", file.getAbsolutePath()});
            process.waitFor();
            if (process.exitValue() != 0) {
                String string = null;
                return string;
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            pin = process.getInputStream();
            StreamUtils.copyStream(pin, bout);
            String output = new String(bout.toByteArray());
            Matcher matcher = MDLS_COMMENT_PATTERN.matcher(output);
            if (matcher.find()) {
                String group = matcher.group();
                String string = group.substring(1, group.length() - 1);
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            LOGGER.info("Caught exception", e);
            String string = null;
            return string;
        }
        finally {
            if (pin != null) {
                try {
                    pin.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

