/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathTokenizer
implements Enumeration<String> {
    private String separators;
    private boolean reverseOrder;
    private String[] tokens;
    private int currentIndex;
    private StringBuffer currentPath;
    private String lastSeparator;

    public PathTokenizer(String path, String separators, boolean reverseOrder) {
        this.separators = separators;
        this.reverseOrder = reverseOrder;
        StringTokenizer st = new StringTokenizer(path, separators, true);
        Vector<String> tokensV = new Vector<String>();
        while (st.hasMoreTokens()) {
            tokensV.add(st.nextToken());
        }
        this.tokens = new String[tokensV.size()];
        int nbTokens = this.tokens.length;
        if (reverseOrder) {
            for (int i = 0; i < nbTokens; ++i) {
                this.tokens[i] = (String)tokensV.elementAt(nbTokens - i - 1);
            }
        } else {
            tokensV.toArray(this.tokens);
        }
        this.currentPath = reverseOrder ? new StringBuffer(path) : new StringBuffer(path.length());
        this.skipSeparators();
    }

    private void skipSeparators() {
        String token;
        this.lastSeparator = "";
        while (this.currentIndex < this.tokens.length && this.separators.indexOf(token = this.tokens[this.currentIndex]) != -1) {
            this.lastSeparator = this.lastSeparator + token;
            this.handleToken(token);
            ++this.currentIndex;
        }
    }

    public boolean hasMoreFilenames() {
        return this.currentIndex < this.tokens.length;
    }

    private void handleToken(String token) {
        if (this.reverseOrder) {
            this.currentPath.setLength(this.currentPath.length() - token.length());
        } else {
            this.currentPath.append(token);
        }
    }

    public String nextFilename() throws NoSuchElementException {
        if (this.currentIndex < this.tokens.length) {
            String token = this.tokens[this.currentIndex++];
            this.handleToken(token);
            this.skipSeparators();
            return token;
        }
        throw new NoSuchElementException();
    }

    public String getCurrentPath() {
        return this.currentPath.toString();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreFilenames();
    }

    @Override
    public String nextElement() throws NoSuchElementException {
        return this.nextFilename();
    }
}

