/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.util;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileURL;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathUtils.class);

    public static ResolvedDestination resolveDestination(String destPath, AbstractFile baseFolder) {
        FileURL destURL;
        try {
            destURL = FileURL.getFileURL(destPath);
        }
        catch (MalformedURLException e) {
            if (baseFolder == null) {
                return null;
            }
            String separator = baseFolder.getSeparator();
            FileURL baseFolderURL = baseFolder.getURL();
            destURL = (FileURL)baseFolderURL.clone();
            String basePath = destURL.getPath();
            if (!destPath.equals("")) {
                destURL.setPath(basePath + (basePath.endsWith(separator) ? "" : separator) + destPath);
            }
            try {
                destURL = FileURL.getFileURL(destURL.toString(false));
                destURL.setCredentials(baseFolderURL.getCredentials());
                destURL.importProperties(baseFolderURL);
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
        AbstractFile destFile = FileFactory.getFile(destURL);
        if (destFile == null) {
            LOGGER.info("could not resolve a file for {}", destURL);
            return null;
        }
        boolean destFileExists = destFile.exists();
        if (destFileExists && (destFile.isDirectory() || destPath.endsWith(destFile.getSeparator()) && destFile.isBrowsable())) {
            return new ResolvedDestination(destFile, 0, destFile);
        }
        AbstractFile destParent = destFile.getParent();
        if (destParent == null || !destParent.exists()) {
            return null;
        }
        return new ResolvedDestination(destFile, destFileExists ? 1 : 2, destParent);
    }

    public static String removeLeadingSeparator(String path, String separator) {
        if (path.startsWith(separator)) {
            return path.substring(separator.length(), path.length());
        }
        return path;
    }

    public static String removeTrailingSeparator(String path) {
        char lastChar;
        int len = path.length();
        if (len > 0 && ((lastChar = path.charAt(len - 1)) == '/' || lastChar == '\\')) {
            return path.substring(0, len - 1);
        }
        return path;
    }

    public static String removeTrailingSeparator(String path, String separator) {
        if (path.endsWith(separator)) {
            return path.substring(0, path.length() - separator.length());
        }
        return path;
    }

    public static boolean pathEquals(String path1, String path2, String separator) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return path1 == null;
        }
        if (path1.equals(path2)) {
            return true;
        }
        int len1 = path1.length();
        int len2 = path2.length();
        int separatorLen = separator.length();
        if (Math.abs(len1 - len2) == separatorLen && (len1 > len2 ? path1.startsWith(path2) : path2.startsWith(path1))) {
            String diff = len1 > len2 ? path1.substring(len1 - separatorLen) : path2.substring(len2 - separatorLen);
            return separator.equals(diff);
        }
        return false;
    }

    public static int getPathHashCode(String path, String separator) {
        return path.endsWith(separator) ? path.substring(0, path.length() - separator.length()).hashCode() : path.hashCode();
    }

    public static String removeLeadingFragments(String path, String separator, int nbFragments) {
        path = PathUtils.removeLeadingSeparator(path, separator);
        if (nbFragments == 0) {
            return path;
        }
        int pos = -1;
        for (int i = 0; i < nbFragments && (pos = path.indexOf(separator, pos + 1)) != -1; ++i) {
        }
        if (pos == -1 || pos == path.length() - 1) {
            return "";
        }
        return path.substring(pos + 1, path.length());
    }

    public static int getDepth(String path, String separator) {
        int pos;
        if (path.equals("") || path.equals(separator)) {
            return 0;
        }
        int depth = 1;
        int n = pos = path.startsWith(separator) ? 1 : 0;
        while ((pos = path.indexOf(separator, pos + 1)) != -1) {
            ++depth;
        }
        if (path.endsWith(separator)) {
            --depth;
        }
        return depth;
    }

    public static class ResolvedDestination {
        private AbstractFile file;
        private AbstractFile folder;
        private int type;

        private ResolvedDestination(AbstractFile destinationFile, int destinationType, AbstractFile destinationFolder) {
            this.file = destinationFile;
            this.type = destinationType;
            this.folder = destinationFolder;
        }

        public AbstractFile getDestinationFile() {
            return this.file;
        }

        public AbstractFile getDestinationFolder() {
            return this.folder;
        }

        public int getDestinationType() {
            return this.type;
        }
    }
}

