/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.util;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.PathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceLoader.class);
    private static ClassLoader defaultClassLoader = ResourceLoader.class.getClassLoader();

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static URL getPackageResourceAsURL(Package ppackage, String name) {
        return ResourceLoader.getPackageResourceAsURL(ppackage, name, ResourceLoader.getDefaultClassLoader(), null);
    }

    public static URL getPackageResourceAsURL(Package ppackage, String name, ClassLoader classLoader, AbstractFile rootPackageFile) {
        return ResourceLoader.getResourceAsURL(ResourceLoader.getRelativePackagePath(ppackage) + "/" + name, classLoader, rootPackageFile);
    }

    public static URL getResourceAsURL(String path) {
        return ResourceLoader.getResourceAsURL(path, ResourceLoader.getDefaultClassLoader(), null);
    }

    public static URL getResourceAsURL(String path, ClassLoader classLoader, AbstractFile rootPackageFile) {
        path = ResourceLoader.removeLeadingSlash(path);
        if (rootPackageFile == null) {
            return classLoader.getResource(path);
        }
        String separator = rootPackageFile.getSeparator();
        String nativePath = separator.equals("/") ? path : path.replace("/", separator);
        try {
            Enumeration<URL> resourceEnum = classLoader.getResources(path);
            String rootPackagePath = rootPackageFile.getAbsolutePath();
            String resourcePath = rootPackageFile.getAbsolutePath(true) + nativePath;
            while (resourceEnum.hasMoreElements()) {
                URL resourceURL = resourceEnum.nextElement();
                if (!("jar".equals(resourceURL.getProtocol()) ? ResourceLoader.getJarFilePath(resourceURL).equals(rootPackagePath) : ResourceLoader.normalizeUrlPath(ResourceLoader.getDecodedURLPath(resourceURL)).equals(resourcePath))) continue;
                return resourceURL;
            }
        }
        catch (IOException e) {
            LOGGER.info("Failed to lookup resource {}", path, e);
            return null;
        }
        return null;
    }

    public static InputStream getPackageResourceAsStream(Package ppackage, String name) {
        return ResourceLoader.getPackageResourceAsStream(ppackage, name, ResourceLoader.getDefaultClassLoader(), null);
    }

    public static InputStream getPackageResourceAsStream(Package ppackage, String name, ClassLoader classLoader, AbstractFile rootPackageFile) {
        return ResourceLoader.getResourceAsStream(ResourceLoader.getRelativePackagePath(ppackage) + "/" + name, classLoader, rootPackageFile);
    }

    public static InputStream getResourceAsStream(String path) {
        return ResourceLoader.getResourceAsStream(path, ResourceLoader.getDefaultClassLoader(), null);
    }

    public static InputStream getResourceAsStream(String path, ClassLoader classLoader, AbstractFile rootPackageFile) {
        try {
            URL resourceURL = ResourceLoader.getResourceAsURL(path, classLoader, rootPackageFile);
            return resourceURL == null ? null : resourceURL.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static AbstractFile getRootPackageAsFile(Class<?> aClass) {
        String aClassRelPath;
        URL aClassURL;
        ClassLoader classLoader = aClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ResourceLoader.getDefaultClassLoader();
        }
        if ((aClassURL = ResourceLoader.getResourceAsURL(aClassRelPath = ResourceLoader.getRelativeClassPath(aClass), classLoader, null)) == null) {
            return null;
        }
        if ("jar".equals(aClassURL.getProtocol())) {
            return FileFactory.getFile(ResourceLoader.getJarFilePath(aClassURL));
        }
        String aClassPath = ResourceLoader.getLocalFilePath(aClassURL);
        return FileFactory.getFile(aClassPath.substring(0, aClassPath.length() - aClassRelPath.length()));
    }

    public static String getRelativePackagePath(Package ppackage) {
        return ppackage.getName().replace('.', '/');
    }

    public static String getRelativeClassPath(Class<?> cclass) {
        return cclass.getName().replace('.', '/') + ".class";
    }

    private static String getJarFilePath(URL url) {
        String path = ResourceLoader.getDecodedURLPath(url);
        int pos = path.indexOf(".jar!");
        if (pos == -1) {
            return path;
        }
        return ResourceLoader.normalizeUrlPath(path.substring(0, pos + 4));
    }

    private static String getLocalFilePath(URL url) {
        return ResourceLoader.normalizeUrlPath(ResourceLoader.getDecodedURLPath(url));
    }

    private static String removeLeadingSlash(String path) {
        return PathUtils.removeLeadingSeparator(path, "/");
    }

    private static String normalizeUrlPath(String path) {
        String separator;
        if (path.startsWith("http:") || path.startsWith("https:")) {
            return path;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5, path.length());
        }
        if (LocalFile.hasRootDrives() && path.startsWith("/")) {
            path = ResourceLoader.removeLeadingSlash(path);
        }
        if (!"/".equals(separator = LocalFile.SEPARATOR)) {
            path = path.replace("/", separator);
        }
        return path;
    }

    private static String getDecodedURLPath(URL url) {
        try {
            return URLDecoder.decode(url.getPath(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

