/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.io;

import com.mucommander.commons.io.StreamUtils;
import com.mucommander.commons.io.bom.BOM;
import com.mucommander.commons.io.bom.BOMConstants;
import com.mucommander.commons.io.bom.BOMInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BinaryDetector {
    public static boolean guessBinary(byte[] b, int off, int len) {
        try {
            int i;
            BOMInputStream bin = new BOMInputStream(new ByteArrayInputStream(b, off, len));
            BOM bom = bin.getBOM();
            if (bom != null && (bom.equals(BOMConstants.UTF16_BE_BOM) || bom.equals(BOMConstants.UTF16_LE_BOM) || bom.equals(BOMConstants.UTF32_BE_BOM) || bom.equals(BOMConstants.UTF32_LE_BOM))) {
                return false;
            }
            while ((i = bin.read()) != -1) {
                if (i != 0) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean guessBinary(InputStream in) throws IOException {
        byte[] bytes = new byte[1024];
        return BinaryDetector.guessBinary(bytes, 0, StreamUtils.readUpTo(in, bytes));
    }
}

